/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.units.SimpleUnit;

public class TransformBuilders {
    private static final Logger log = LoggerFactory.getLogger(TransformBuilders.class);

    public static double getFalseEastingScaleFactor(NetcdfDataset ds, AttributeContainer ctv) {
        String units = TransformBuilders.getGeoCoordinateUnits(ds, ctv);
        return TransformBuilders.getFalseEastingScaleFactor(units);
    }

    public static String getGeoCoordinateUnits(NetcdfDataset ds, AttributeContainer ctv) {
        String units = ctv.findAttributeString("units", null);
        if (units == null) {
            Variable xvar;
            ImmutableList<CoordinateAxis> axes = ds.getCoordinateAxes();
            for (CoordinateAxis axis : axes) {
                if (axis.getAxisType() != AxisType.GeoX) continue;
                Variable v = axis.getOriginalVariable();
                units = v == null ? axis.getUnitsString() : v.getUnitsString();
                break;
            }
            if (units == null && (xvar = ds.getRootGroup().findVariableByAttribute("_CoordinateAxisType", AxisType.GeoX.toString())) != null) {
                units = xvar.getUnitsString();
            }
        }
        return units;
    }

    public static double getFalseEastingScaleFactor(String geoCoordinateUnits) {
        if (geoCoordinateUnits != null) {
            try {
                SimpleUnit unit = SimpleUnit.factoryWithExceptions(geoCoordinateUnits);
                return unit.convertTo(1.0, SimpleUnit.kmUnit);
            }
            catch (Exception e) {
                log.warn(geoCoordinateUnits + " not convertible to km");
            }
        }
        return 1.0;
    }

    static double getEarthRadiusInKm(AttributeContainer ctv) {
        double earth_radius = ctv.findAttributeDouble("earth_radius", 6371229.0);
        if (earth_radius > 10000.0) {
            earth_radius *= 0.001;
        }
        return earth_radius;
    }
}

