/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.unidata.geoloc.projection.UtmProjection;

public class UTM
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "universal_transverse_mercator";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double zoned = ctv.findAttributeDouble("utm_zone_number", Double.NaN);
        if (Double.isNaN(zoned)) {
            zoned = ctv.findAttributeDouble("UTM_zone", Double.NaN);
        }
        if (Double.isNaN(zoned)) {
            throw new IllegalArgumentException("No zone was specified");
        }
        int zone = (int)zoned;
        boolean isNorth = zone > 0;
        zone = Math.abs(zone);
        double axis = ctv.findAttributeDouble("semimajor_axis", 0.0);
        double f = ctv.findAttributeDouble("inverse_flattening", 0.0);
        UtmProjection proj = axis != 0.0 ? new UtmProjection(axis, f, zone, isNorth) : new UtmProjection(zone, isNorth);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

