/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.unidata.geoloc.projection.sat.VerticalPerspectiveView;

public class VerticalPerspective
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "vertical_perspective";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        this.readStandardParams(ctv, geoCoordinateUnits);
        double distance = ctv.findAttributeDouble("perspective_point_height", Double.NaN);
        if (Double.isNaN(distance)) {
            distance = ctv.findAttributeDouble("height_above_earth", Double.NaN);
        }
        if (Double.isNaN(this.lon0) || Double.isNaN(this.lat0) || Double.isNaN(distance)) {
            throw new IllegalArgumentException("Vertical Perspective must have: longitude_of_projection_origin, latitude_of_projection_origin, and perspective_point_height(or height_above_earth) attributes");
        }
        VerticalPerspectiveView proj = new VerticalPerspectiveView(this.lat0, this.lon0, this.earth_radius, distance / 1000.0, this.false_easting, this.false_northing);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

