/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.AttributeContainer;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;
import ucar.unidata.util.Parameter;

public abstract class AbstractVerticalCTBuilder
implements VerticalCTBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractVerticalCTBuilder.class);
    private Formatter errBuffer;

    @Override
    public void setErrorBuffer(Formatter errBuffer) {
        this.errBuffer = errBuffer;
    }

    @Override
    public abstract String getTransformName();

    protected boolean addParameter(CoordinateTransform.Builder<?> rs, String paramName, NetcdfFile ds, String varNameEscaped) {
        if (null == ds.findVariable(varNameEscaped)) {
            if (null != this.errBuffer) {
                this.errBuffer.format("CoordTransBuilder %s: no Variable named %s%n", this.getTransformName(), varNameEscaped);
            }
            return false;
        }
        rs.addParameter(new Parameter(paramName, varNameEscaped));
        return true;
    }

    String getFormula(AttributeContainer ctv) {
        String formula = ctv.findAttributeString("formula_terms", null);
        if (null == formula) {
            if (null != this.errBuffer) {
                this.errBuffer.format("CoordTransBuilder %s: needs attribute 'formula_terms' on Variable %s%n", this.getTransformName(), ctv.getName());
            }
            return null;
        }
        return formula;
    }

    String[] parseFormula(String formula_terms, String termString) {
        String[] formulaTerms = formula_terms.split("[\\s:]+");
        String[] terms = termString.split("[\\s]+");
        String[] values = new String[terms.length];
        block0: for (int i = 0; i < terms.length; ++i) {
            for (int j = 0; j < formulaTerms.length; j += 2) {
                if (!terms[i].equals(formulaTerms[j])) continue;
                values[i] = formulaTerms[j + 1];
                continue block0;
            }
        }
        boolean ok = true;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            if (null != this.errBuffer) {
                this.errBuffer.format("Missing term=%s in the formula '%s' for the vertical transform= %s%n", terms[i], formula_terms, this.getTransformName());
            }
            ok = false;
        }
        return ok ? values : null;
    }
}

