/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.HybridHeight;
import ucar.unidata.util.Parameter;

public class CFHybridHeight
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    private String a;
    private String b;
    private String orog;

    @Override
    public String getTransformName() {
        return VerticalCT.Type.HybridHeight.name();
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "a b orog");
        if (values == null) {
            return null;
        }
        this.a = values[0];
        this.b = values[1];
        this.orog = values[2];
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName("AtmHybridHeight_Transform_" + ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.HybridHeight).setTransformBuilder(this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "height(x,y,z) = a(z) + b(z)*orog(x,y)"));
        if (!this.addParameter(rs, "A_variableName", ds, this.a)) {
            return null;
        }
        if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
            return null;
        }
        if (!this.addParameter(rs, "Orography_variableName", ds, this.orog)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "HybridHeight:orog:" + this.orog + " a:" + this.a + " b:" + this.b;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return HybridHeight.create(ds, timeDim, vCT.getParameters());
    }
}

