/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.AtmosLnPressure;
import ucar.unidata.util.Parameter;

public class CFLnPressure
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    private String p0;
    private String lev;

    @Override
    public String getTransformName() {
        return VerticalCT.Type.LnPressure.name();
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "p0 lev");
        if (values == null) {
            return null;
        }
        this.p0 = values[0];
        this.lev = values[1];
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName("AtmSigma_Transform_" + ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.LnPressure).setTransformBuilder(this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "pressure(z) = p0 * exp(-lev(k))"));
        if (!this.addParameter(rs, "ReferencePressureVariableName", ds, this.p0)) {
            return null;
        }
        if (!this.addParameter(rs, "VerticalCoordinateVariableName", ds, this.lev)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "AtmLnPressure:p0:" + this.p0 + " lev:" + this.lev;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return AtmosLnPressure.create(ds, timeDim, vCT.getParameters());
    }
}

