/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.util.Parameter;

public class CFSigma
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    private String sigma = "";
    private String ps = "";
    private String ptop = "";

    @Override
    public String getTransformName() {
        return VerticalCT.Type.Sigma.name();
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "sigma ps ptop");
        if (values == null) {
            return null;
        }
        this.sigma = values[0];
        this.ps = values[1];
        this.ptop = values[2];
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName("AtmSigma_Transform_" + ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.Sigma).setTransformBuilder(this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ptop + sigma(z)*(surfacePressure(x,y)-ptop)"));
        if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
            return null;
        }
        if (!this.addParameter(rs, "Sigma_variableName", ds, this.sigma)) {
            return null;
        }
        if (!this.addParameter(rs, "PressureTop_variableName", ds, this.ptop)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "Sigma:sigma:" + this.sigma + " ps:" + this.ps + " ptop:" + this.ptop;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return AtmosSigma.create(ds, timeDim, vCT.getParameters());
    }
}

