/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.geoloc.vertical.HybridSigmaPressure;
import ucar.unidata.util.Parameter;

public class CsmSigma
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    @Override
    public String getTransformName() {
        return "csm_sigma_level";
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName("sigma-" + ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.Sigma).setTransformBuilder(this);
        rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ptop + sigma(z)*(surfacePressure(x,y)-ptop)"));
        if (!CsmSigma.addParameter2(rs, "SurfacePressure_variableName", ds, ctv, "PS_var", false)) {
            return null;
        }
        if (!CsmSigma.addParameter2(rs, "Sigma_variableName", ds, ctv, "B_var", false)) {
            return null;
        }
        if (!CsmSigma.addParameter2(rs, "PressureTop_variableName", ds, ctv, "P0_var", false)) {
            return null;
        }
        return rs;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return AtmosSigma.create(ds, timeDim, vCT.getParameters());
    }

    private static boolean addParameter2(CoordinateTransform.Builder<?> rs, String paramName, NetcdfFile ds, AttributeContainer v, String attName, boolean readData) {
        String varName = v.findAttributeString(attName, null);
        if (null == varName) {
            return false;
        }
        Variable dataVar = ds.findVariable(varName = varName.trim());
        if (null == dataVar) {
            return false;
        }
        if (readData) {
            Array data;
            try {
                data = dataVar.read();
            }
            catch (IOException e) {
                return false;
            }
            double[] vals = (double[])data.get1DJavaArray(DataType.DOUBLE);
            rs.addParameter(new Parameter(paramName, vals));
        } else {
            rs.addParameter(new Parameter(paramName, varName));
        }
        return true;
    }

    public static class HybridSigmaPressureBuilder
    extends AbstractVerticalCTBuilder
    implements VerticalTransformBuilder {
        @Override
        public String getTransformName() {
            return "csm_hybrid_sigma_pressure";
        }

        @Override
        public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
            VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName(ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.HybridSigmaPressure).setTransformBuilder(this);
            rs.addParameter(new Parameter("formula", "pressure(x,y,z) = a(z)*p0 + b(z)*surfacePressure(x,y)"));
            if (!CsmSigma.addParameter2(rs, "SurfacePressure_variableName", ds, ctv, "PS_var", false)) {
                return null;
            }
            if (!CsmSigma.addParameter2(rs, "A_variableName", ds, ctv, "A_var", false)) {
                return null;
            }
            if (!CsmSigma.addParameter2(rs, "B_variableName", ds, ctv, "B_var", false)) {
                return null;
            }
            if (!CsmSigma.addParameter2(rs, "P0_variableName", ds, ctv, "P0_var", false)) {
                return null;
            }
            return rs;
        }

        @Override
        public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
            return HybridSigmaPressure.create(ds, timeDim, vCT.getParameters());
        }
    }
}

