/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.VTfromExistingData;
import ucar.unidata.util.Parameter;

public class VExplicitField
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    @Override
    public String getTransformName() {
        return VerticalCT.Type.Existing3DField.name();
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName(ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.Existing3DField).setTransformBuilder(this);
        String fieldName = ctv.findAttributeString("existingDataField", null);
        if (null == fieldName) {
            throw new IllegalArgumentException("ExplicitField Vertical Transform must have attribute existingDataField");
        }
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("existingDataField", fieldName));
        return rs;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return VTfromExistingData.create(ds, timeDim, vCT.getParameters());
    }
}

