/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.transform.vertical.AbstractVerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.OceanSG2;
import ucar.unidata.util.Parameter;

public class VOceanSG2
extends AbstractVerticalCTBuilder
implements VerticalTransformBuilder {
    private String s = "";
    private String eta = "";
    private String depth = "";
    private String c = "";
    private String depth_c = "";

    @Override
    public String getTransformName() {
        return VerticalCT.Type.OceanSG2.name();
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "s C eta depth depth_c");
        if (values == null) {
            return null;
        }
        this.s = values[0];
        this.c = values[1];
        this.eta = values[2];
        this.depth = values[3];
        this.depth_c = values[4];
        VerticalCT.Builder<?> rs = ((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName("OceanSG2_Transform_" + ctv.getName())).setAuthority(this.getTransformName())).setVerticalType(VerticalCT.Type.OceanSG2).setTransformBuilder(this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = eta(x,y) + (eta(x,y) + depth([n],x,y)) * ((depth_c*s(z) + depth([n],x,y)*C(z))/(depth_c+depth([n],x,y)))"));
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "S_variableName", ds, this.s)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_c_variableName", ds, this.depth_c)) {
            return null;
        }
        if (!this.addParameter(rs, "c_variableName", ds, this.c)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanSG2: s:" + this.s + " c:" + this.c + " eta:" + this.eta + " depth:" + this.depth + " depth_c:" + this.depth_c;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return OceanSG2.create(ds, timeDim, vCT.getParameters());
    }
}

