/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.vertical;

import java.util.Formatter;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;
import ucar.unidata.geoloc.vertical.WRFEta;

public class WRFEtaTransformBuilder
implements VerticalCTBuilder,
VerticalTransformBuilder {
    private final CoordinatesHelper.Builder coords;
    private final CoordinateSystem.Builder<?> cs;

    public WRFEtaTransformBuilder(CoordinatesHelper.Builder coords, CoordinateSystem.Builder<?> cs) {
        this.coords = coords;
        this.cs = cs;
    }

    @Override
    public VerticalCT.Builder<?> makeVerticalCT(NetcdfFile ds, AttributeContainer ctv1) {
        VerticalCT.Type type = VerticalCT.Type.WRFEta;
        AttributeContainerMutable atts = new AttributeContainerMutable(this.getTransformName());
        atts.addAttribute(new Attribute("height formula", "height(x,y,z) = (PH(x,y,z) + PHB(x,y,z)) / 9.81"));
        atts.addAttribute(new Attribute("perturbation_geopotential", "PH"));
        atts.addAttribute(new Attribute("base_geopotential", "PHB"));
        atts.addAttribute(new Attribute("pressure formula", "pressure(x,y,z) = P(x,y,z) + PB(x,y,z)"));
        atts.addAttribute(new Attribute("perturbation_presure", "P"));
        atts.addAttribute(new Attribute("base_presure", "PB"));
        if (this.coords.findAxisByType(this.cs, AxisType.GeoX).isPresent()) {
            atts.addAttribute(new Attribute("staggered_x", "" + this.isStaggered(AxisType.GeoX)));
        } else {
            atts.addAttribute(new Attribute("staggered_x", "" + this.isStaggered2(AxisType.Lon, 1)));
        }
        if (this.coords.findAxisByType(this.cs, AxisType.GeoY).isPresent()) {
            atts.addAttribute(new Attribute("staggered_y", "" + this.isStaggered(AxisType.GeoY)));
        } else {
            atts.addAttribute(new Attribute("staggered_y", "" + this.isStaggered2(AxisType.Lat, 0)));
        }
        atts.addAttribute(new Attribute("staggered_z", "" + this.isStaggered(AxisType.GeoZ)));
        this.coords.findAxisByType(this.cs, AxisType.GeoZ).ifPresent(a -> atts.addAttribute(new Attribute("eta", "" + a.getFullName())));
        return ((VerticalCT.Builder)((VerticalCT.Builder)((VerticalCT.Builder)VerticalCT.builder().setName(this.getTransformName())).setCtvAttributes(atts)).setTransformType(TransformType.Vertical)).setVerticalType(type).setTransformBuilder(this);
    }

    @Override
    public String getTransformName() {
        return VerticalCT.Type.WRFEta.name() + this.cs.coordAxesNames;
    }

    @Override
    public void setErrorBuffer(Formatter sb) {
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return WRFEta.create(ds, timeDim, vCT.getParameters());
    }

    private boolean isStaggered(AxisType type) {
        return this.coords.findAxisByType(this.cs, type).map(a -> a.shortName != null && a.shortName.endsWith("stag")).orElse(false);
    }

    private boolean isStaggered2(AxisType type, int dimIndex) {
        return this.coords.findAxisByType(this.cs, type).map(a -> {
            String dimName = a.getDimensionName(dimIndex);
            return dimName != null && dimName.endsWith("stag");
        }).orElse(false);
    }
}

