/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.util.Misc;

class CoordToGridAxis1D {
    private static final Logger log = LoggerFactory.getLogger(CoordToGridAxis1D.class);
    final boolean isInterval;
    final boolean boundsAreContiguous;
    final boolean boundsAreRegular;
    final double[] coords;
    final double[] edge;
    final double[] bound1;
    final double[] bound2;
    final int ncoords;
    final boolean isRegular;
    boolean isAscending;

    CoordToGridAxis1D(String name, Array<Double> values, Optional<Array<Double>> boundsOpt) {
        Preconditions.checkArgument((values.getRank() < 2 ? 1 : 0) != 0);
        int count = 0;
        this.ncoords = (int)values.length();
        this.coords = new double[this.ncoords];
        for (Double val : values) {
            this.coords[count++] = val;
        }
        this.isRegular = this.calcIsRegular(this.coords);
        if (boundsOpt.isPresent()) {
            Array<Double> bounds = boundsOpt.get();
            Preconditions.checkArgument((bounds.length() == (long)(2 * this.ncoords) ? 1 : 0) != 0, (Object)("incorrect boundsVar length data for variable " + name));
            Preconditions.checkArgument((bounds.getRank() == 2 && bounds.getShape()[1] == 2 ? 1 : 0) != 0, (Object)("incorrect boundsVar shape data for variable " + name));
            double[] value1 = new double[this.ncoords];
            double[] value2 = new double[this.ncoords];
            for (int i = 0; i < this.ncoords; ++i) {
                value1[i] = bounds.get(i, 0);
                value2[i] = bounds.get(i, 1);
            }
            boolean contig = true;
            for (int i = 0; i < this.ncoords - 1; ++i) {
                if (Misc.nearlyEquals(value1[i + 1], value2[i])) continue;
                contig = false;
            }
            if (contig) {
                this.edge = new double[this.ncoords + 1];
                this.edge[0] = value1[0];
                System.arraycopy(value2, 0, this.edge, 1, this.ncoords);
                this.boundsAreContiguous = true;
                this.boundsAreRegular = this.calcIsRegular(this.edge);
            } else {
                this.boundsAreContiguous = false;
                this.boundsAreRegular = false;
                this.edge = null;
            }
            this.bound1 = value1;
            this.bound2 = value2;
            this.isInterval = true;
        } else {
            this.bound1 = null;
            this.edge = null;
            this.bound2 = null;
            this.isInterval = false;
            this.boundsAreContiguous = false;
            this.boundsAreRegular = false;
        }
    }

    private boolean calcIsRegular(double[] values) {
        boolean isRegular;
        int nvalues = values.length;
        if (nvalues <= 2) {
            isRegular = true;
            this.isAscending = true;
        } else {
            this.isAscending = values[0] < values[1];
            double increment = (values[nvalues - 1] - values[0]) / (double)(nvalues - 1);
            boolean isMonotonic = true;
            isRegular = true;
            for (int i = 1; i < nvalues; ++i) {
                if (!Misc.nearlyEquals(values[i] - values[i - 1], increment, 0.005)) {
                    isRegular = false;
                }
                if (this.isAscending) {
                    if (!(values[i] <= values[i - 1])) continue;
                    isMonotonic = false;
                    continue;
                }
                if (!(values[i] >= values[i - 1])) continue;
                isMonotonic = false;
            }
        }
        return isRegular;
    }

    void correctLongitudeWrap() {
        boolean monotonic = true;
        for (int i = 0; i < this.coords.length - 1; ++i) {
            monotonic &= this.isAscending ? this.coords[i] < this.coords[i + 1] : this.coords[i] > this.coords[i + 1];
        }
        if (monotonic) {
            return;
        }
        boolean cross = false;
        if (this.isAscending) {
            for (int i = 0; i < this.coords.length; ++i) {
                if (cross) {
                    int n = i;
                    this.coords[n] = this.coords[n] + 360.0;
                }
                if (cross || i >= this.coords.length - 1 || !(this.coords[i] > this.coords[i + 1])) continue;
                cross = true;
            }
        } else {
            for (int i = 0; i < this.coords.length; ++i) {
                if (cross) {
                    int n = i;
                    this.coords[n] = this.coords[n] - 360.0;
                }
                if (cross || i >= this.coords.length - 1 || !(this.coords[i] < this.coords[i + 1])) continue;
                cross = true;
            }
        }
    }

    void extract(GridAxis1D.Builder<?> builder) {
        builder.setNcoords(this.ncoords);
        if (!this.isInterval) {
            if (this.isRegular) {
                builder.setSpacing(GridAxis.Spacing.regularPoint);
                double starting = this.coords[0];
                double ending = this.coords[this.ncoords - 1];
                double increment = this.ncoords == 1 ? 0.0 : (ending - starting) / (double)(this.ncoords - 1);
                builder.setRegular(this.ncoords, starting, ending, increment);
            } else {
                builder.setSpacing(GridAxis.Spacing.irregularPoint);
                builder.setValues(this.coords);
                double starting = this.coords[0];
                double ending = this.coords[this.ncoords - 1];
                double resolution = this.ncoords == 1 ? 0.0 : (ending - starting) / (double)(this.ncoords - 1);
                builder.setResolution(Math.abs(resolution));
            }
        } else if (this.boundsAreRegular) {
            builder.setSpacing(GridAxis.Spacing.regularInterval);
            double starting = this.edge[0];
            double ending = this.edge[this.edge.length - 1];
            double increment = this.ncoords == 1 ? 0.0 : (ending - starting) / (double)this.ncoords;
            builder.setRegular(this.ncoords, starting, ending, increment);
        } else if (this.boundsAreContiguous) {
            builder.setSpacing(GridAxis.Spacing.contiguousInterval);
            builder.setValues(this.edge);
            double starting = this.edge[0];
            double ending = this.edge[this.edge.length - 1];
            double resolution = this.ncoords == 1 ? 0.0 : (ending - starting) / (double)this.ncoords;
            builder.setResolution(Math.abs(resolution));
        } else {
            builder.setSpacing(GridAxis.Spacing.discontiguousInterval);
            double[] bounds = new double[2 * this.ncoords];
            int count = 0;
            for (int i = 0; i < this.ncoords; ++i) {
                bounds[count++] = this.bound1[i];
                bounds[count++] = this.bound2[i];
            }
            builder.setValues(bounds);
            double starting = bounds[0];
            double ending = bounds[2 * this.ncoords - 1];
            double resolution = this.ncoords == 1 ? 0.0 : (ending - starting) / (double)(this.ncoords - 1);
            builder.setResolution(Math.abs(resolution));
        }
    }
}

