/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.internal.grid.TimeHelper;
import ucar.nc2.time.CalendarDate;

class CoordinateAxis1DTimeExtractor {
    private static final Logger log = LoggerFactory.getLogger(CoordinateAxis1DTimeExtractor.class);
    final TimeHelper timeHelper;
    @Nullable
    final List<CalendarDate> cdates;

    CoordinateAxis1DTimeExtractor(CoordinateAxis coordAxis) {
        Preconditions.checkArgument((coordAxis.getArrayType() == ArrayType.CHAR || coordAxis.getRank() < 2 ? 1 : 0) != 0);
        this.timeHelper = TimeHelper.factory(coordAxis.getUnitsString(), coordAxis.attributes());
        Formatter errMessages = new Formatter();
        try {
            this.cdates = coordAxis.getArrayType() == ArrayType.CHAR ? this.makeTimesFromChar(coordAxis, errMessages) : (coordAxis.getArrayType() == ArrayType.STRING ? this.makeTimesFromStrings(coordAxis, errMessages) : null);
        }
        catch (IOException ioe) {
            throw new RuntimeException(errMessages.toString(), ioe);
        }
    }

    private List<CalendarDate> makeTimesFromChar(Variable org, Formatter errMessages) throws IOException {
        Preconditions.checkArgument((org.getArrayType() == ArrayType.CHAR ? 1 : 0) != 0);
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>();
        Array<Byte> data = org.readArray();
        Array<String> dateStrings = Arrays.makeStringsFromChar(data);
        for (String coordValue : dateStrings) {
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            result.add(cd);
        }
        return result;
    }

    private List<CalendarDate> makeTimesFromStrings(Variable org, Formatter errMessages) throws IOException {
        Preconditions.checkArgument((org.getArrayType() == ArrayType.STRING ? 1 : 0) != 0);
        int ncoords = (int)org.getSize();
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords);
        Array<?> data = org.readArray();
        for (String coordValue : data) {
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            result.add(cd);
        }
        return result;
    }

    private CalendarDate makeCalendarDateFromStringCoord(String coordValue, Variable org, Formatter errMessages) {
        try {
            return this.timeHelper.makeCalendarDateFromOffset(coordValue);
        }
        catch (IllegalArgumentException e) {
            errMessages.format("Bad time coordinate '%s' in dataset '%s'%n", coordValue, org.getDatasetLocation());
            log.info("Bad time coordinate '{}' in dataset '{}'", (Object)coordValue, (Object)org.getDatasetLocation());
            throw new RuntimeException(errMessages.toString(), e);
        }
    }
}

