/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

@Immutable
public class CoordinateAxis2DExtractor {
    private static final Logger log = LoggerFactory.getLogger(CoordinateAxis2DExtractor.class);
    private final int ntimes;
    private final Array<Double> coords;
    private final Array<Double> bounds;
    private final Array<Integer> hours;
    private final boolean isInterval;
    private boolean isContiguous;
    private final AttributeContainer attributes;
    private final String getRuntimeAxisName;

    CoordinateAxis2DExtractor(CoordinateAxis dtCoordAxis) {
        Array<?> data;
        Preconditions.checkArgument((dtCoordAxis.getRank() == 2 ? 1 : 0) != 0);
        this.attributes = dtCoordAxis.attributes();
        Attribute hourAtt = this.attributes.findAttribute("hoursFrom0z");
        Preconditions.checkNotNull((Object)hourAtt);
        this.hours = hourAtt.getArrayValues();
        this.getRuntimeAxisName = this.attributes.findAttributeString("runtimeCoordinate", null);
        try {
            data = dtCoordAxis.readArray();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values " + ioe);
            throw new IllegalStateException(ioe);
        }
        if (data.getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        this.ntimes = data.getShape()[1];
        this.coords = Arrays.toDouble(data);
        this.isInterval = this.computeIsInterval(dtCoordAxis);
        Array<Double> tempBounds = this.makeBoundsFromAux(dtCoordAxis);
        if (tempBounds == null) {
            tempBounds = this.makeBoundsFromMidpoints(this.coords);
        }
        this.bounds = tempBounds;
    }

    public String getRuntimeAxisName() {
        return this.getRuntimeAxisName;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public Array<Integer> getHourOffsets() {
        return this.hours;
    }

    public Array<Double> getMidpoints() {
        return this.coords;
    }

    public int getNtimes() {
        return this.ntimes;
    }

    @Nullable
    public Array<Double> getBounds() {
        return this.bounds;
    }

    private boolean computeIsInterval(CoordinateAxis dtCoordAxis) {
        String boundsVarName = this.attributes.findAttributeString("bounds", null);
        if (boundsVarName == null) {
            return false;
        }
        VariableDS boundsVar = (VariableDS)dtCoordAxis.getParentGroup().findVariableLocal(boundsVarName);
        if (null == boundsVar) {
            return false;
        }
        if (3 != boundsVar.getRank()) {
            return false;
        }
        if (!dtCoordAxis.getDimension(0).equals(boundsVar.getDimension(0))) {
            return false;
        }
        if (!dtCoordAxis.getDimension(1).equals(boundsVar.getDimension(1))) {
            return false;
        }
        return 2 == boundsVar.getDimension(2).getLength();
    }

    @Nullable
    private Array<Double> makeBoundsFromAux(CoordinateAxis dtCoordAxis) {
        Array<?> data;
        String boundsVarName = this.attributes.findAttributeString("bounds", null);
        if (boundsVarName == null) {
            return null;
        }
        VariableDS boundsVar = (VariableDS)dtCoordAxis.getParentGroup().findVariableLocal(boundsVarName);
        Preconditions.checkNotNull((Object)boundsVar);
        try {
            data = boundsVar.readArray();
        }
        catch (IOException e) {
            log.warn("CoordinateAxis2DExtractor.makeBoundsFromAux read failed ", (Throwable)e);
            return null;
        }
        return Arrays.toDouble(data);
    }

    private Array<Double> makeBoundsFromMidpoints(Array<Double> midpoints) {
        Preconditions.checkArgument((midpoints.getRank() == 2 ? 1 : 0) != 0);
        int[] shape = midpoints.getShape();
        int nrows = shape[0];
        int ncols = shape[1];
        double[] bounds = new double[nrows * ncols * 2];
        int count = 0;
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                bounds[count++] = col == 0 ? midpoints.get(row, 0) - (midpoints.get(row, 1) - midpoints.get(row, 0)) / 2.0 : (midpoints.get(row, col) + midpoints.get(row, col - 1)) / 2.0;
                bounds[count++] = col == ncols - 1 ? midpoints.get(row, col) + (midpoints.get(row, col) - midpoints.get(row, col - 1)) / 2.0 : (midpoints.get(row, col) + midpoints.get(row, col + 1)) / 2.0;
            }
        }
        return Arrays.factory(ArrayType.DOUBLE, new int[]{nrows, ncols, 2}, bounds);
    }
}

