/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.dataset.DatasetClassifier;
import ucar.nc2.internal.grid.GridHorizCS;
import ucar.nc2.internal.grid.Grids;
import ucar.unidata.geoloc.Projection;

@Immutable
public class GridCS
implements GridCoordinateSystem {
    private final ImmutableList<GridAxis> axes;
    private final FeatureType featureType;
    private final String name;
    private final GridHorizCoordinateSystem horizCsys;
    private final ImmutableMultimap<GridAxis, GridAxis> dependMap;

    @Override
    public String getName() {
        return this.name;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public ImmutableList<GridAxis> getGridAxes() {
        return this.axes;
    }

    @Override
    public Optional<GridAxis> findAxis(String axisName) {
        for (GridAxis axis : this.axes) {
            if (!axis.getName().equals(axisName)) continue;
            return Optional.of(axis);
        }
        return Optional.empty();
    }

    public GridAxis findCoordAxis(AxisType ... axisType) {
        for (AxisType type : axisType) {
            for (GridAxis axis : this.axes) {
                if (axis.getAxisType() != type) continue;
                return axis;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GridAxis1D getEnsembleAxis() {
        return (GridAxis1D)this.findCoordAxis(AxisType.Ensemble);
    }

    @Override
    public GridAxis getXHorizAxis() {
        return this.findCoordAxis(AxisType.GeoX, AxisType.Lon);
    }

    @Override
    public GridAxis getYHorizAxis() {
        return this.findCoordAxis(AxisType.GeoY, AxisType.Lat);
    }

    @Override
    @Nullable
    public GridAxis1D getVerticalAxis() {
        return (GridAxis1D)this.findCoordAxis(AxisType.GeoZ, AxisType.Height, AxisType.Pressure);
    }

    @Override
    @Nullable
    public GridAxis1DTime getTimeAxis() {
        return (GridAxis1DTime)this.findCoordAxis(AxisType.Time);
    }

    @Override
    @Nullable
    public GridAxis1DTime getRunTimeAxis() {
        return (GridAxis1DTime)this.findCoordAxis(AxisType.RunTime);
    }

    @Override
    @Nullable
    public GridAxis getTimeOffsetAxis() {
        return this.findCoordAxis(AxisType.TimeOffset);
    }

    @Override
    public GridHorizCoordinateSystem getHorizCoordSystem() {
        return this.horizCsys;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void show(Formatter f, boolean showCoords) {
        f.format("Coordinate System (%s)%n", this.getName());
        this.showCoordinateAxis(this.getRunTimeAxis(), f, showCoords);
        this.showCoordinateAxis(this.getEnsembleAxis(), f, showCoords);
        this.showCoordinateAxis(this.getTimeAxis(), f, showCoords);
        this.showCoordinateAxis(this.getVerticalAxis(), f, showCoords);
        this.showCoordinateAxis(this.getYHorizAxis(), f, showCoords);
        this.showCoordinateAxis(this.getXHorizAxis(), f, showCoords);
        if (this.horizCsys.getProjection() != null) {
            f.format(" Projection: %s %s%n", this.horizCsys.getProjection().getName(), this.horizCsys.getProjection().paramsToString());
        }
        f.format(" LLbb=%s%n", this.horizCsys.getLatLonBoundingBox());
        if (this.horizCsys.getProjection() != null && !this.horizCsys.isLatLon()) {
            f.format(" bb= %s%n", this.horizCsys.getBoundingBox());
        }
    }

    private void showCoordinateAxis(GridAxis axis, Formatter f, boolean showCoords) {
        if (axis == null) {
            return;
        }
        String className = axis.getClass().getName();
        int pos = className.lastIndexOf(".");
        f.format(" %s (%s) ", axis.getName(), className.substring(pos + 1));
        if (showCoords) {
            this.showCoords(axis, f);
        }
        f.format("%n", new Object[0]);
    }

    private void showCoords(GridAxis axis, Formatter f) {
        if (axis instanceof GridAxis1D) {
            GridAxis1D axis1D = (GridAxis1D)axis;
            if (!axis1D.isInterval()) {
                for (double anE : axis1D.getCoordsAsArray()) {
                    f.format("%f,", anE);
                }
            } else {
                for (int i = 0; i < axis1D.getNcoords(); ++i) {
                    f.format("(%f,%f) = %f%n", axis1D.getCoordEdge1(i), axis1D.getCoordEdge2(i), axis1D.getCoordEdge2(i) - axis1D.getCoordEdge1(i));
                }
            }
        }
        f.format(" %s", axis.getUnits());
    }

    @Override
    public String showFnSummary() {
        if (this.featureType == null) {
            return "";
        }
        Formatter f2 = new Formatter();
        f2.format("%s(", this.featureType.toString());
        ArrayList<GridAxis> otherAxes = new ArrayList<GridAxis>();
        int count = 0;
        for (GridAxis axis : this.axes) {
            if (axis.getDependenceType() != GridAxis.DependenceType.independent) {
                otherAxes.add(axis);
                continue;
            }
            if (count > 0) {
                f2.format(",", new Object[0]);
            }
            f2.format("%s", axis.getAxisType() == null ? axis.getName() : axis.getAxisType().getCFAxisName());
            ++count;
        }
        f2.format(")", new Object[0]);
        count = 0;
        for (GridAxis axis : otherAxes) {
            f2.format(count == 0 ? ": " : ",", new Object[0]);
            f2.format("%s", axis.getAxisType() == null ? axis.getName() : axis.getAxisType().getCFAxisName());
            ++count;
        }
        return f2.toString();
    }

    @Override
    public List<RangeIterator> getRanges() {
        ArrayList<RangeIterator> result = new ArrayList<RangeIterator>();
        for (GridAxis axis : this.axes) {
            if (axis.getDependenceType() != GridAxis.DependenceType.independent) continue;
            result.add(axis.getRangeIterator());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCS gridCS = (GridCS)o;
        boolean ok = this.featureType == gridCS.featureType && this.name.equals(gridCS.name) && this.horizCsys.equals(gridCS.horizCsys);
        for (GridAxis axis : this.getGridAxes()) {
            ok = gridCS.findAxis(axis.getName()).isPresent();
        }
        return ok;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.axes, this.featureType, this.name, this.horizCsys});
    }

    @Override
    public Optional<GridCoordinateSystem> subset(GridSubset params, Formatter errlog) {
        Formatter errMessages = new Formatter();
        Builder<?> builder = this.toBuilder();
        builder.clearAxes();
        for (GridAxis axis : this.getGridAxes()) {
            GridAxis subsetAxis;
            if (axis.getDependenceType() == GridAxis.DependenceType.dependent || (subsetAxis = axis.subset(params, errMessages)) == null) continue;
            builder.addAxis(subsetAxis);
            if (!(subsetAxis instanceof GridAxis1D)) continue;
            GridAxis1D subsetInd = (GridAxis1D)subsetAxis;
            for (GridAxis dependent : this.dependMap.get((Object)axis)) {
                dependent.subsetDependent(subsetInd, errMessages).ifPresent(builder::addAxis);
            }
        }
        for (GridAxis xyaxis : this.horizCsys.subset(params, errlog)) {
            builder.addAxis(xyaxis);
        }
        String errs = errMessages.toString();
        if (!errs.isEmpty()) {
            errlog.format("%s", errs);
            return Optional.empty();
        }
        return Optional.of(builder.build());
    }

    GridCS(DatasetClassifier.CoordSysClassifier classifier, Map<String, GridAxis> gridAxes) {
        this.featureType = classifier.getFeatureType();
        ArrayList<Object> axesb = new ArrayList<Object>();
        for (CoordinateAxis axis : classifier.getAxesUsed()) {
            GridAxis gaxis = gridAxes.get(axis.getFullName());
            axesb.add(Preconditions.checkNotNull((Object)gaxis, (Object)("Missing Coordinate Axis " + axis.getFullName())));
        }
        axesb.sort(new Grids.AxisComparator());
        this.axes = ImmutableList.copyOf(axesb);
        List names = this.axes.stream().map(GridAxis::getName).collect(Collectors.toList());
        this.name = String.join((CharSequence)" ", names);
        this.horizCsys = GridHorizCS.create(this.getXHorizAxis(), this.getYHorizAxis(), classifier.getProjection());
        this.dependMap = this.makeDependMap();
    }

    private ImmutableMultimap<GridAxis, GridAxis> makeDependMap() {
        ImmutableMultimap.Builder dependMapb = ImmutableMultimap.builder();
        for (GridAxis axis : this.axes) {
            if (axis.getDependenceType() != GridAxis.DependenceType.dependent) continue;
            for (String dependsOn : axis.getDependsOn()) {
                this.findAxis(dependsOn).ifPresent(indAxis -> dependMapb.put((Object)axis, indAxis));
            }
        }
        return dependMapb.build();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(GridCS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)builder.setName(this.name).setFeatureType(this.featureType)).setProjection(this.horizCsys.getProjection())).setAxes((List<GridAxis>)this.axes);
        return builder;
    }

    private GridCS(Builder<?> builder) {
        Preconditions.checkNotNull((Object)((Builder)builder).axes);
        Preconditions.checkNotNull((Object)((Builder)builder).projection);
        this.name = ((Builder)builder).name;
        this.featureType = ((Builder)builder).featureType;
        this.axes = ImmutableList.copyOf((Collection)((Builder)builder).axes);
        this.horizCsys = GridHorizCS.create(this.getXHorizAxis(), this.getYHorizAxis(), ((Builder)builder).projection);
        this.dependMap = this.makeDependMap();
    }

    private GridCS(Builder<?> builder, List<GridAxis> gridAxes) {
        Preconditions.checkNotNull((Object)((Builder)builder).axesNames);
        Preconditions.checkNotNull((Object)((Builder)builder).projection);
        this.name = ((Builder)builder).name;
        this.featureType = ((Builder)builder).featureType;
        ImmutableList.Builder axesb = ImmutableList.builder();
        for (String name : ((Builder)builder).axesNames) {
            gridAxes.stream().filter(a -> a.getName().equals(name)).findFirst().ifPresent(arg_0 -> ((ImmutableList.Builder)axesb).add(arg_0));
        }
        this.axes = axesb.build();
        this.horizCsys = GridHorizCS.create(this.getXHorizAxis(), this.getYHorizAxis(), ((Builder)builder).projection);
        this.dependMap = this.makeDependMap();
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private FeatureType featureType;
        private Projection projection;
        private ArrayList<GridAxis> axes = new ArrayList();
        private List<String> axesNames;
        private List<String> transformNames;
        private boolean built;

        protected abstract T self();

        public T setName(String name) {
            this.name = name;
            return this.self();
        }

        public T setFeatureType(FeatureType featureType) {
            this.featureType = featureType;
            return this.self();
        }

        public T setProjection(Projection projection) {
            this.projection = projection;
            return this.self();
        }

        public T clearAxes() {
            this.axes = new ArrayList();
            return this.self();
        }

        public T setAxes(List<GridAxis> axes) {
            this.axes = new ArrayList<GridAxis>(axes);
            return this.self();
        }

        public T addAxis(GridAxis axis) {
            this.axes.add(axis);
            return this.self();
        }

        public T setAxisNames(List<String> axesNames) {
            this.axesNames = axesNames;
            return this.self();
        }

        public GridCS build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new GridCS(this);
        }

        public GridCS build(List<GridAxis> gridAxes) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new GridCS(this, gridAxes);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

