/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.Section;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.internal.grid.GridCS;

@Immutable
class GridIndexPermuter {
    private final int[] shape;
    private final int xDimOrgIndex;
    private final int yDimOrgIndex;
    private final int zDimOrgIndex;
    private final int eDimOrgIndex;
    private final int tDimOrgIndex;
    private final int toDimOrgIndex;
    private final int rtDimOrgIndex;

    GridIndexPermuter(GridCS gcs, VariableDS vds) {
        this.shape = vds.getShape();
        this.xDimOrgIndex = this.findDimension(vds, gcs.getXHorizAxis());
        this.yDimOrgIndex = this.findDimension(vds, gcs.getYHorizAxis());
        this.zDimOrgIndex = this.findDimension(vds, gcs.getVerticalAxis());
        this.eDimOrgIndex = this.findDimension(vds, gcs.getEnsembleAxis());
        this.tDimOrgIndex = this.findDimension(vds, gcs.getTimeAxis());
        this.toDimOrgIndex = this.findDimension(vds, gcs.getTimeOffsetAxis());
        this.rtDimOrgIndex = this.findDimension(vds, gcs.getRunTimeAxis());
    }

    private int findDimension(VariableDS vds, GridAxis want) {
        if (want == null) {
            return -1;
        }
        ImmutableList<Dimension> dims = vds.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension d = (Dimension)dims.get(i);
            if (d.getShortName() == null || !d.getShortName().equals(want.getName())) continue;
            return i;
        }
        String depends = want.getDependsOn().size() == 1 ? (String)want.getDependsOn().get(0) : null;
        for (int i = 0; i < dims.size(); ++i) {
            Dimension d = (Dimension)dims.get(i);
            if (d.getShortName() == null || !d.getShortName().equals(depends)) continue;
            return i;
        }
        return -1;
    }

    Section permute(Section subset) {
        Range[] varRange = new Range[this.shape.length];
        block11: for (Range r : subset.getRanges()) {
            AxisType type = AxisType.valueOf(r.name());
            switch (type) {
                case Lon: 
                case GeoX: {
                    varRange[this.xDimOrgIndex] = r;
                    continue block11;
                }
                case Lat: 
                case GeoY: {
                    varRange[this.yDimOrgIndex] = r;
                    continue block11;
                }
                case Height: 
                case Pressure: 
                case GeoZ: {
                    varRange[this.zDimOrgIndex] = r;
                    continue block11;
                }
                case Time: {
                    varRange[this.tDimOrgIndex] = r;
                    continue block11;
                }
                case TimeOffset: {
                    varRange[this.toDimOrgIndex] = r;
                    continue block11;
                }
                case RunTime: {
                    varRange[this.rtDimOrgIndex] = r;
                    continue block11;
                }
                case Ensemble: {
                    varRange[this.eDimOrgIndex] = r;
                    continue block11;
                }
            }
            throw new RuntimeException("Unknown axis type " + (Object)((Object)type));
        }
        Section s = new Section(Arrays.asList(varRange));
        try {
            return Section.fill(s, this.shape);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "GridIndexPermuter{shape=" + Arrays.toString(this.shape) + ", eDimOrgIndex=" + this.eDimOrgIndex + ", rtDimOrgIndex=" + this.rtDimOrgIndex + ", toDimOrgIndex=" + this.toDimOrgIndex + ", tDimOrgIndex=" + this.tDimOrgIndex + ", zDimOrgIndex=" + this.zDimOrgIndex + ", yDimOrgIndex=" + this.yDimOrgIndex + ", xDimOrgIndex=" + this.xDimOrgIndex + '}';
    }
}

