/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.nc2.grid.GridAxis2D;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.internal.grid.GridHorizCS;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.sat.Geostationary;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;
import ucar.unidata.geoloc.projection.sat.VerticalPerspectiveView;

public class GridLatLon2D
extends GridHorizCS {
    private final GridAxis2D lon2D;
    private final GridAxis2D lat2D;

    GridLatLon2D(GridAxis2D xaxis, GridAxis2D yaxis, @Nullable Projection projection, String horizStaggerType) {
        super(null, null, projection, horizStaggerType);
        Preconditions.checkArgument((boolean)Misc.compare(xaxis.getShape(), yaxis.getShape(), new Formatter()));
        this.lon2D = xaxis;
        this.lat2D = yaxis;
    }

    public int[] getShape() {
        return this.lon2D.getShape();
    }

    public GridAxis2D getLatAxis() {
        return this.lat2D;
    }

    public GridAxis2D getLonAxis() {
        return this.lon2D;
    }

    @Override
    public boolean isLatLon() {
        return true;
    }

    @Override
    public boolean isRegular() {
        return false;
    }

    @Override
    @Nullable
    public String getGeoUnits() {
        return null;
    }

    @Override
    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            this.mapArea = new ProjectionRect(this.lon2D.getCoordMin(), this.lat2D.getCoordMin(), this.lon2D.getCoordMax(), this.lat2D.getCoordMax());
        }
        return this.mapArea;
    }

    @Override
    public LatLonPoint getLatLon(int xindex, int yindex) {
        double x = this.lon2D.getCoordValue(yindex, xindex);
        double y = this.lat2D.getCoordValue(yindex, xindex);
        return LatLonPoint.create(y, x);
    }

    @Override
    public Optional<GridHorizCoordinateSystem.CoordReturn> findXYindexFromCoord(double x, double y) {
        return Optional.empty();
    }

    @Override
    public List<Range> getRangesFromLatLonRect(LatLonRect rect) throws InvalidRangeException {
        Projection proj = this.getProjection();
        if (!(proj == null || proj instanceof VerticalPerspectiveView || proj instanceof MSGnavigation || proj instanceof Geostationary)) {
            LatLonRect bb = this.getLatLonBoundingBox();
            LatLonRect rect2 = bb.intersect(rect);
            if (null == rect2) {
                throw new InvalidRangeException("Request Bounding box does not intersect Grid ");
            }
            rect = rect2;
        }
        LatLonPoint llpt = rect.getLowerLeftPoint();
        LatLonPoint urpt = rect.getUpperRightPoint();
        LatLonPoint lrpt = rect.getLowerRightPoint();
        LatLonPoint ulpt = rect.getUpperLeftPoint();
        double minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
        double miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
        double maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
        double maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        double minLon = this.lon2D.getCoordMin();
        minx = LatLonPoints.lonNormalFrom(minx, minLon);
        maxx = LatLonPoints.lonNormalFrom(maxx, minLon);
        int[] shape = new int[]{0, 0};
        int nj = shape[0];
        int ni = shape[1];
        int mini = Integer.MAX_VALUE;
        int minj = Integer.MAX_VALUE;
        int maxi = -1;
        int maxj = -1;
        for (int j = 0; j < nj; ++j) {
            for (int i = 0; i < ni; ++i) {
                double lat = this.lat2D.getCoordValue(j, i);
                double lon = this.lon2D.getCoordValue(j, i);
                if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                if (i > maxi) {
                    maxi = i;
                }
                if (i < mini) {
                    mini = i;
                }
                if (j > maxj) {
                    maxj = j;
                }
                if (j >= minj) continue;
                minj = j;
            }
        }
        if (mini > maxi || minj > maxj) {
            mini = 0;
            minj = 0;
            maxi = -1;
            maxj = -1;
        }
        ArrayList<Range> list = new ArrayList<Range>();
        list.add(new Range(minj, maxj));
        list.add(new Range(mini, maxi));
        return list;
    }
}

