/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.internal.dataset.DatasetClassifier;
import ucar.nc2.internal.grid.GridCS;
import ucar.nc2.internal.grid.GridVariable;
import ucar.nc2.internal.grid.Grids;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class GridNetcdfDataset
implements GridDataset {
    private static Logger log = LoggerFactory.getLogger(GridNetcdfDataset.class);
    private final NetcdfDataset ncd;
    private final FeatureType featureType;
    private final ArrayList<GridCS> coordsys = new ArrayList();
    private final Map<String, GridAxis> gridAxes;
    private final ArrayList<Grid> grids = new ArrayList();
    private final Multimap<GridCS, Grid> gridsets;
    private boolean wasClosed = false;

    public static Optional<GridNetcdfDataset> create(NetcdfDataset ncd, Formatter errInfo) throws IOException {
        DatasetClassifier facc;
        Set<NetcdfDataset.Enhance> enhance = ncd.getEnhanceMode();
        if (enhance == null || !enhance.contains((Object)NetcdfDataset.Enhance.CoordSystems)) {
            enhance = NetcdfDataset.getDefaultEnhanceMode();
            ncd = NetcdfDatasets.enhance(ncd, enhance, null);
        }
        return (facc = new DatasetClassifier(ncd, errInfo)).getFeatureType() == FeatureType.GRID ? Optional.of(new GridNetcdfDataset(ncd, facc, errInfo)) : Optional.empty();
    }

    private GridNetcdfDataset(NetcdfDataset ncd, DatasetClassifier classifier, Formatter errInfo) {
        GridAxis gridAxis;
        this.ncd = ncd;
        this.featureType = classifier.getFeatureType();
        this.gridAxes = new HashMap<String, GridAxis>();
        for (CoordinateAxis axis : classifier.getIndependentAxes()) {
            if (axis.getFullName().startsWith("Best/")) continue;
            if (axis.getRank() < 2) {
                gridAxis = Grids.extractGridAxis1D(ncd, axis, GridAxis.DependenceType.independent);
                this.gridAxes.put(axis.getFullName(), gridAxis);
                continue;
            }
            log.warn("Independent gridAxis {} rank > 1", (Object)axis.getFullName());
            errInfo.format("Independent gridAxis %s rank > 1", axis.getFullName());
        }
        for (CoordinateAxis axis : classifier.getDependentAxes()) {
            if (axis.getFullName().startsWith("Best/")) continue;
            if (axis.getRank() < 2) {
                gridAxis = Grids.extractGridAxis1D(ncd, axis, GridAxis.DependenceType.dependent);
                this.gridAxes.put(axis.getFullName(), gridAxis);
                continue;
            }
            if (axis.getAxisType() != AxisType.TimeOffset || axis.getRank() != 2) continue;
            gridAxis = Grids.extractGridAxisOffset2D(axis, GridAxis.DependenceType.dependent, this.gridAxes);
            this.gridAxes.put(axis.getFullName(), gridAxis);
        }
        HashMap<String, TrackGridCS> trackCsConverted = new HashMap<String, TrackGridCS>();
        for (DatasetClassifier.CoordSysClassifier csc : classifier.getCoordinateSystemsUsed()) {
            if (csc.getName().startsWith("Best/")) continue;
            GridCS gcs = new GridCS(csc, this.gridAxes);
            this.coordsys.add(gcs);
            trackCsConverted.put(csc.getName(), new TrackGridCS(csc, gcs));
        }
        this.coordsys.sort((o1, o2) -> o2.getGridAxes().size() - o1.getGridAxes().size());
        this.gridsets = ArrayListMultimap.create();
        block3: for (Variable v : ncd.getVariables()) {
            VariableEnhanced ve;
            ArrayList<CoordinateSystem> css;
            if (v.getFullName().startsWith("Best/") || (css = new ArrayList<CoordinateSystem>((Collection<CoordinateSystem>)(ve = (VariableEnhanced)((Object)v)).getCoordinateSystems())).isEmpty()) continue;
            css.sort((o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
            for (CoordinateSystem cs : css) {
                TrackGridCS track = (TrackGridCS)trackCsConverted.get(cs.getName());
                if (track == null) continue;
                GridCS gcs = track.gridCS;
                ImmutableSet<Dimension> domain = Dimensions.makeDomain(track.csc.getAxesUsed(), false);
                if (gcs == null || gcs.getFeatureType() != this.featureType || !Dimensions.isCoordinateSystemFor(domain, v)) continue;
                GridVariable grid = new GridVariable(gcs, (VariableDS)ve);
                this.grids.add(grid);
                this.gridsets.put((Object)gcs, (Object)grid);
                continue block3;
            }
        }
    }

    private void makeHorizRanges() {
        LatLonRect.Builder llbbBuilder = null;
        ProjectionRect.Builder projBBbuilder = null;
        for (GridCoordinateSystem gcs : this.gridsets.keySet()) {
            ProjectionRect bb = gcs.getHorizCoordSystem().getBoundingBox();
            if (projBBbuilder == null) {
                projBBbuilder = bb.toBuilder();
            } else if (bb != null) {
                projBBbuilder.add(bb);
            }
            LatLonRect llbb = gcs.getHorizCoordSystem().getLatLonBoundingBox();
            if (llbbBuilder == null) {
                llbbBuilder = llbb.toBuilder();
                continue;
            }
            if (llbb == null) continue;
            llbbBuilder.extend(llbb);
        }
        if (llbbBuilder != null) {
            LatLonRect latLonRect = llbbBuilder.build();
        }
    }

    public FeatureType getCoverageType() {
        return this.featureType;
    }

    @Override
    public String getName() {
        String loc = this.ncd.getLocation();
        int pos = loc.lastIndexOf(47);
        if (pos < 0) {
            pos = loc.lastIndexOf(92);
        }
        return pos < 0 ? loc : loc.substring(pos + 1);
    }

    @Override
    public String getLocation() {
        return this.ncd.getLocation();
    }

    @Override
    public AttributeContainer attributes() {
        return this.ncd.getRootGroup().attributes();
    }

    @Override
    public ImmutableList<GridCoordinateSystem> getGridCoordinateSystems() {
        return ImmutableList.copyOf(this.coordsys);
    }

    @Override
    public ImmutableList<GridAxis> getGridAxes() {
        return ImmutableList.copyOf(this.gridAxes.values());
    }

    @Override
    public ImmutableList<Grid> getGrids() {
        return ImmutableList.copyOf(this.grids);
    }

    @Override
    public Optional<Grid> findGrid(String name) {
        return this.grids.stream().filter(g -> g.getName().equals(name)).findFirst();
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public String toString() {
        Formatter f = new Formatter();
        this.toString(f);
        return f.toString();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.wasClosed) {
                this.ncd.close();
            }
        }
        finally {
            this.wasClosed = true;
        }
    }

    private static class TrackGridCS {
        DatasetClassifier.CoordSysClassifier csc;
        GridCS gridCS;

        public TrackGridCS(DatasetClassifier.CoordSysClassifier csc, GridCS gridCS) {
            this.csc = csc;
            this.gridCS = gridCS;
        }
    }
}

