/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.RangeIterator;
import ucar.array.Section;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.grid.GridCS;
import ucar.nc2.internal.grid.GridIndexPermuter;

@Immutable
public class GridVariable
implements Grid {
    private final GridCoordinateSystem cs;
    private final VariableDS vds;
    private final GridIndexPermuter permuter;

    GridVariable(GridCS cs, VariableDS vds) {
        this.cs = cs;
        this.vds = vds;
        this.permuter = new GridIndexPermuter(cs, vds);
    }

    @Override
    public GridCoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    @Override
    public String getName() {
        return this.vds.getShortName();
    }

    @Override
    public String getUnits() {
        return this.vds.getUnitsString() == null ? "" : this.vds.getUnitsString();
    }

    @Override
    public String getDescription() {
        return this.vds.getDescription() == null ? "" : this.vds.getDescription();
    }

    @Override
    public AttributeContainer attributes() {
        return this.vds.attributes();
    }

    @Override
    public ArrayType getArrayType() {
        return this.vds.getArrayType();
    }

    @Override
    public boolean hasMissing() {
        return this.vds.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        return this.vds.isMissing(val);
    }

    public String toString() {
        return this.vds + "\n permuter=" + this.permuter + '}';
    }

    @Override
    public GridReferencedArray readData(GridSubset subset) throws IOException, InvalidRangeException {
        Formatter errlog = new Formatter();
        Optional<GridCoordinateSystem> opt = this.cs.subset(subset, errlog);
        if (!opt.isPresent()) {
            throw new InvalidRangeException(errlog.toString());
        }
        GridCoordinateSystem subsetCoordSys = opt.get();
        List<RangeIterator> rangeIters = subsetCoordSys.getRanges();
        ArrayList<Range> ranges = new ArrayList<Range>();
        boolean hasComposite = false;
        for (RangeIterator ri : rangeIters) {
            ranges.add((Range)ri);
        }
        Array<Number> data = this.readDataSection(new Section(ranges), true);
        return GridReferencedArray.create(this.getName(), this.getArrayType(), data, subsetCoordSys);
    }

    private Array<Number> readDataSection(Section subset, boolean canonicalOrder) throws InvalidRangeException, IOException {
        Array<Number> dataVolume = this.vds.readArray(this.permuter.permute(subset));
        return dataVolume;
    }
}

