/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.Arrays;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.grid.GridAxisOffsetTimeRegular;
import ucar.nc2.internal.grid.CoordToGridAxis1D;
import ucar.nc2.internal.grid.CoordinateAxis1DTimeExtractor;
import ucar.nc2.internal.grid.CoordinateAxis2DExtractor;

class Grids {
    private static final Logger log = LoggerFactory.getLogger(Grids.class);

    Grids() {
    }

    static GridAxis1D extractGridAxis1D(NetcdfDataset ncd, CoordinateAxis axis, GridAxis.DependenceType dependenceType) {
        AxisType axisType = axis.getAxisType();
        GridAxis1D.Builder builder = axisType == AxisType.Time || axisType == AxisType.RunTime ? (GridAxis1D.Builder)GridAxis1DTime.builder(axis).setAxisType(axis.getAxisType()) : (GridAxis1D.Builder)GridAxis1D.builder(axis).setAxisType(axis.getAxisType());
        Grids.extractGridAxis1D(ncd, axis, builder, dependenceType);
        return builder.build();
    }

    private static void extractGridAxis1D(NetcdfDataset ncd, CoordinateAxis axis, GridAxis1D.Builder<?> builder, GridAxis.DependenceType dependenceTypeFromClassifier) {
        GridAxis.DependenceType dependenceType;
        Preconditions.checkArgument((axis.getRank() < 2 ? 1 : 0) != 0);
        if (axis.isCoordinateVariable()) {
            dependenceType = GridAxis.DependenceType.independent;
        } else if (ncd.isIndependentCoordinate(axis)) {
            dependenceType = dependenceTypeFromClassifier;
            builder.setDependsOn(axis.getDimension(0).getShortName());
        } else if (axis.isScalar()) {
            dependenceType = GridAxis.DependenceType.scalar;
        } else {
            dependenceType = GridAxis.DependenceType.dependent;
            ArrayList<String> dependsOn = new ArrayList<String>();
            for (Dimension d : axis.getDimensions()) {
                dependsOn.add(d.makeFullName(axis));
            }
            builder.setDependsOn(dependsOn);
        }
        builder.setDependenceType(axis.isScalar() ? GridAxis.DependenceType.scalar : dependenceType);
        CoordToGridAxis1D converter = new CoordToGridAxis1D(builder.toString(), Grids.readValues(axis), Grids.readBounds(axis));
        if (axis.getAxisType() == AxisType.Lon) {
            converter.correctLongitudeWrap();
        }
        converter.extract(builder);
        if (builder instanceof GridAxis1DTime.Builder) {
            GridAxis1DTime.Builder timeBuilder = (GridAxis1DTime.Builder)builder;
            CoordinateAxis1DTimeExtractor extractTime = new CoordinateAxis1DTimeExtractor(axis);
            timeBuilder.setTimeHelper(extractTime.timeHelper);
            if (extractTime.cdates != null) {
                timeBuilder.setCalendarDates(extractTime.cdates);
            }
        }
    }

    private static Array<Double> readValues(CoordinateAxis axis) {
        Array<?> data;
        try {
            data = axis.readArray();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        return Arrays.toDouble(data);
    }

    private static Optional<Array<Double>> readBounds(CoordinateAxis axis) {
        Array<?> boundsData;
        String boundsVarName = axis.attributes().findAttributeString("bounds", null);
        if (boundsVarName == null) {
            return Optional.empty();
        }
        VariableDS boundsVar = (VariableDS)axis.getParentGroup().findVariableLocal(boundsVarName);
        if (null == boundsVar) {
            return Optional.empty();
        }
        if (2 != boundsVar.getRank()) {
            return Optional.empty();
        }
        if (axis.getDimension(0) != boundsVar.getDimension(0)) {
            return Optional.empty();
        }
        if (2 != boundsVar.getDimension(1).getLength()) {
            return Optional.empty();
        }
        try {
            boundsData = boundsVar.readArray();
        }
        catch (IOException e) {
            log.warn("GridAxis1DBuilder.makeBoundsFromAux read failed ", (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(Arrays.toDouble(boundsData));
    }

    static GridAxisOffsetTimeRegular extractGridAxisOffset2D(CoordinateAxis axis, GridAxis.DependenceType dependenceType, Map<String, GridAxis> gridAxes) {
        Preconditions.checkArgument((axis.getAxisType() == AxisType.TimeOffset ? 1 : 0) != 0);
        Preconditions.checkArgument((axis.getRank() == 2 ? 1 : 0) != 0);
        GridAxisOffsetTimeRegular.Builder builder = (GridAxisOffsetTimeRegular.Builder)((GridAxisOffsetTimeRegular.Builder)GridAxisOffsetTimeRegular.builder(axis).setAxisType(axis.getAxisType())).setDependenceType(dependenceType);
        CoordinateAxis2DExtractor extract = new CoordinateAxis2DExtractor(axis);
        builder.setMidpoints(extract.getMidpoints());
        builder.setBounds(extract.getBounds());
        builder.setHourOffsets(extract.getHourOffsets());
        builder.setSpacing(extract.isInterval() ? GridAxis.Spacing.discontiguousInterval : GridAxis.Spacing.irregularPoint);
        Preconditions.checkNotNull((Object)extract.getRuntimeAxisName());
        GridAxis runtime = gridAxes.get(extract.getRuntimeAxisName());
        Preconditions.checkNotNull((Object)runtime, (Object)extract.getRuntimeAxisName());
        Preconditions.checkArgument((boolean)(runtime instanceof GridAxis1DTime), (Object)extract.getRuntimeAxisName());
        Preconditions.checkArgument((runtime.getAxisType() == AxisType.RunTime ? 1 : 0) != 0, (Object)extract.getRuntimeAxisName());
        builder.setRuntimeAxis((GridAxis1DTime)runtime);
        return builder.build();
    }

    public static class AxisComparator
    implements Comparator<GridAxis> {
        @Override
        public int compare(GridAxis c1, GridAxis c2) {
            Preconditions.checkNotNull((Object)c1);
            Preconditions.checkNotNull((Object)c2);
            AxisType t1 = c1.getAxisType();
            AxisType t2 = c2.getAxisType();
            Preconditions.checkNotNull((Object)((Object)t1));
            Preconditions.checkNotNull((Object)((Object)t2));
            return t1.axisOrder() - t2.axisOrder();
        }
    }
}

