/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.grid;

import com.google.common.base.Splitter;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class RemoteGridEncode {
    public static String encodeDataRequest(GridSubset subset, String varname) {
        Formatter f = new Formatter();
        Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();
        f.format("var=%s", urlParamEscaper.escape(varname));
        block30: for (Map.Entry<String, Object> entry : subset.getEntries()) {
            switch (entry.getKey()) {
                case "latlonBB": {
                    LatLonRect llbb = (LatLonRect)entry.getValue();
                    f.format("&north=%s&south=%s&west=%s&east=%s", llbb.getLatMax(), llbb.getLatMin(), llbb.getLonMin(), llbb.getLonMax());
                    continue block30;
                }
                case "projBB": {
                    ProjectionRect projRect = (ProjectionRect)entry.getValue();
                    f.format("&minx=%s&miny=%s&maxx=%s&maxy=%s", projRect.getMinX(), projRect.getMinY(), projRect.getMaxX(), projRect.getMaxY());
                    continue block30;
                }
                case "latlonPoint": {
                    LatLonPoint llPoint = (LatLonPoint)entry.getValue();
                    f.format("&lat=%s&lon=%s", llPoint.getLatitude(), llPoint.getLongitude());
                    continue block30;
                }
                case "horizStride": {
                    f.format("&%s=%s", "horizStride", entry.getValue());
                    continue block30;
                }
                case "runtime": {
                    f.format("&runtime=%s", entry.getValue());
                    continue block30;
                }
                case "runtimeLatest": {
                    f.format("&runtime=latest", new Object[0]);
                    continue block30;
                }
                case "runtimeAll": {
                    f.format("&runtime=all", new Object[0]);
                    continue block30;
                }
                case "timeRange": {
                    CalendarDateRange timeRange = (CalendarDateRange)entry.getValue();
                    f.format("&time_start=%s&time_end=%s", timeRange.getStart(), timeRange.getEnd());
                    continue block30;
                }
                case "timePresent": {
                    f.format("&time=present", new Object[0]);
                    continue block30;
                }
                case "timeAll": {
                    f.format("&time=all", new Object[0]);
                    continue block30;
                }
                case "timeOffsetAll": {
                    f.format("&timeOffset=all", new Object[0]);
                    continue block30;
                }
                case "timeOffsetFirst": {
                    f.format("&timeOffset=first", new Object[0]);
                    continue block30;
                }
                case "gridName": {
                    continue block30;
                }
            }
            f.format("&%s=%s", entry.getKey(), entry.getValue());
        }
        return f.toString();
    }

    public static GridSubset decodeDataRequest(String request) {
        String varname;
        String svalue;
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        Splitter splitRequest = Splitter.on((char)'&');
        Splitter splitPair = Splitter.on((char)'=');
        for (String pair : splitRequest.split((CharSequence)request)) {
            List keyvalue = splitPair.splitToList((CharSequence)pair);
            if (keyvalue.size() == 2) {
                keyValueMap.put((String)keyvalue.get(0), (String)keyvalue.get(1));
                continue;
            }
            if (keyvalue.size() != 1) continue;
            keyValueMap.put((String)keyvalue.get(0), (String)null);
        }
        GridSubset subset = new GridSubset();
        List<Double> params = RemoteGridEncode.getParameters(keyValueMap, "north", "south", "east", "west");
        if (params != null) {
            LatLonRect llbb = LatLonRect.builder(params.get(1), params.get(3), params.get(0), params.get(2)).build();
            subset.setLatLonBoundingBox(llbb);
        }
        if ((params = RemoteGridEncode.getParameters(keyValueMap, "minx", "miny", "maxx", "maxy")) != null) {
            ProjectionRect rect = ProjectionRect.builder(params.get(0), params.get(1), params.get(2), params.get(3)).build();
            subset.setProjectionBoundingBox(rect);
        }
        if ((params = RemoteGridEncode.getParameters(keyValueMap, "lat", "lon")) != null) {
            LatLonPoint llpt = LatLonPoint.create(params.get(0), params.get(1));
            subset.setLatLonPoint(llpt);
        }
        if ((params = RemoteGridEncode.getParameters(keyValueMap, "horizStride")) != null) {
            subset.setHorizStride(params.get(0).intValue());
        }
        if ((svalue = (String)keyValueMap.get("runtime")) != null) {
            if (svalue.equals("latest")) {
                subset.setRunTimeLatest();
            } else if (svalue.equals("all")) {
                subset.setRunTimeAll();
            } else {
                try {
                    CalendarDate cd = CalendarDate.parseISOformat(null, svalue);
                    subset.setRunTime(cd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((varname = (String)keyValueMap.get("var")) != null) {
            // empty if block
        }
        return subset;
    }

    private static List<Double> getParameters(Map<String, String> keyValueMap, String ... keys) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (String key : keys) {
            double value;
            String svalue = keyValueMap.get(key);
            if (svalue == null) {
                return null;
            }
            try {
                value = Double.parseDouble(svalue);
            }
            catch (Exception e) {
                return null;
            }
            result.add(value);
        }
        return result;
    }

    private static CalendarDate getCalendarDate(Map<String, String> keyValueMap, String key) {
        String svalue = keyValueMap.get(key);
        if (svalue == null) {
            return null;
        }
        try {
            return CalendarDate.parseISOformat(null, svalue);
        }
        catch (Exception e) {
            return null;
        }
    }
}

