/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.hdf5.DataBTree;
import ucar.nc2.internal.iosp.hdf5.H5header;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.internal.iosp.hdf5.H5objects;

public class H5diagNew {
    private final NetcdfFile ncfile;
    private final H5iosp iosp;

    public H5diagNew(NetcdfFile ncfile, H5iosp iosp) {
        this.ncfile = ncfile;
        this.iosp = iosp;
    }

    public void showCompress(Formatter f) throws IOException {
        Size totalSize = new Size(0L, 0);
        for (Variable v : this.ncfile.getVariables()) {
            H5header.Vinfo vinfo = (H5header.Vinfo)v.getSPobject();
            this.showCompress(v, vinfo, totalSize, f);
        }
        f.format("%n", new Object[0]);
        f.format(" total bytes   = %d%n", totalSize.nominal);
        f.format(" total storage = %d%n", totalSize.storage);
        f.format(" compression = %f%n", Float.valueOf(totalSize.getRatio()));
        f.format(" nchunks     = %d%n", totalSize.count);
        File raf = new File(this.ncfile.getLocation());
        f.format(" file size    = %d%n", raf.length());
        float overhead = totalSize.storage == 0L ? 0.0f : (float)raf.length() / (float)totalSize.storage;
        f.format(" overhead     = %f%n", Float.valueOf(overhead));
    }

    public void showCompress(Variable v, H5header.Vinfo vinfo, Size total, Formatter f) throws IOException {
        H5objects.MessageDataspace mdt = vinfo.mds;
        long total_elems = 1L;
        f.format("%8s %-40s(", new Object[]{v.getDataType(), v.getShortName()});
        for (int len : mdt.dimLength) {
            f.format("%d ", len);
            total_elems *= (long)len;
        }
        boolean sizeOk = total_elems == v.getSize();
        total_elems = v.getSize();
        long nominalSize = total_elems * (long)v.getElementSize();
        Size size = new Size(nominalSize, 1);
        this.countStorageSize(vinfo, size);
        total.storage += size.storage;
        total.nominal += nominalSize;
        total.count += size.count;
        float ratio = size.storage == 0L ? 0.0f : (float)nominalSize / (float)size.storage;
        f.format(") == %d nelems %s == %d bytes storage = %d (%f) nchunks = %d%n", total_elems, sizeOk ? "" : "*", nominalSize, size.storage, Float.valueOf(ratio), size.count);
    }

    private void countStorageSize(H5header.Vinfo vinfo, Size size) throws IOException {
        DataBTree btree = vinfo.btree;
        if (btree == null || vinfo.useFillValue) {
            size.storage = 0L;
            size.count = 0;
            return;
        }
        int count = 0;
        long total = 0L;
        DataBTree.DataChunkIterator iter = btree.getDataChunkIteratorFilter(null);
        while (iter.hasNext()) {
            DataBTree.DataChunk dc = iter.next();
            total += (long)dc.size;
            ++count;
        }
        size.storage = total;
        size.count = count;
    }

    public long[] countStorageSize(H5header.Vinfo vinfo, Size size, Formatter f) throws IOException {
        long[] result = new long[2];
        DataBTree btree = vinfo.btree;
        if (btree == null) {
            if (f != null) {
                f.format("btree is null%n", new Object[0]);
            }
            return result;
        }
        if (vinfo.useFillValue) {
            if (f != null) {
                f.format("useFillValue - no data is stored%n", new Object[0]);
            }
            return result;
        }
        int count = 0;
        long total = 0L;
        DataBTree.DataChunkIterator iter = btree.getDataChunkIteratorFilter(null);
        while (iter.hasNext()) {
            DataBTree.DataChunk dc = iter.next();
            if (f != null) {
                f.format(" %s%n", dc);
            }
            total += (long)dc.size;
            ++count;
        }
        result[0] = total;
        result[1] = count;
        return result;
    }

    public void deflate(Formatter f, Variable v) {
        H5header.Vinfo vinfo = (H5header.Vinfo)v.getSPobject();
        DataBTree btree = vinfo.btree;
        if (btree == null || vinfo.useFillValue) {
            f.format("%s not chunked%n", v.getShortName());
        }
    }

    public void deflate(Formatter f, DataBTree btree) throws IOException {
        int count = 0;
        long total = 0L;
        DataBTree.DataChunkIterator iter = btree.getDataChunkIteratorFilter(null);
        while (iter.hasNext()) {
            DataBTree.DataChunk dc = iter.next();
            total += (long)dc.size;
            ++count;
        }
    }

    private static class Size {
        long storage;
        long nominal;
        int count;

        private Size(long storage, int count) {
            this.storage = storage;
            this.count = count;
        }

        float getRatio() {
            if (this.storage == 0L) {
                return 0.0f;
            }
            return (float)this.nominal / (float)this.storage;
        }
    }
}

