/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.Arrays;
import ucar.array.ArraysConvert;
import ucar.array.InvalidRangeException;
import ucar.array.Storage;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.hdf4.HdfEos;
import ucar.nc2.internal.iosp.hdf5.H5header;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.internal.iosp.hdf5.H5objects;
import ucar.nc2.internal.iosp.hdf5.H5tiledLayout;
import ucar.nc2.internal.iosp.hdf5.H5tiledLayoutBB;
import ucar.nc2.iosp.IospArrayHelper;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.NetcdfFormatUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class H5iospArrays
extends H5iosp {
    @Override
    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        raf.order(0);
        this.header = new H5header(raf, rootGroup, this);
        this.header.read(null);
        if (useHdfEos) {
            rootGroup.findGroupLocal("HDFEOS_INFORMATION").ifPresent(eosGroup -> {
                try {
                    this.isEos = HdfEos.amendFromODL(raf.getLocation(), this.header, eosGroup);
                }
                catch (IOException e) {
                    log.warn(" HdfEos.amendFromODL failed");
                }
            });
        }
    }

    @Override
    public ucar.array.Array<?> readArrayData(Variable v2, ucar.array.Section section) throws IOException, InvalidRangeException {
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        Preconditions.checkNotNull((Object)vinfo);
        if (debugRead) {
            System.out.printf("%s read %s%n", v2.getFullName(), section);
        }
        return this.readArrayData(v2, vinfo.dataPos, section);
    }

    private ucar.array.Array<?> readArrayData(Variable v2, long dataPos, ucar.array.Section wantSection) throws IOException, InvalidRangeException {
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        ArrayType dataType = v2.getArrayType();
        if (vinfo.useFillValue) {
            Object pa = IospArrayHelper.makePrimitiveArray((int)wantSection.computeSize(), dataType, vinfo.getFillValue());
            if (dataType == ArrayType.CHAR) {
                pa = IospArrayHelper.convertByteToChar((byte[])pa);
            }
            return Arrays.factory(dataType, wantSection.getShape(), pa);
        }
        try {
            Object data;
            Layout layout;
            if (vinfo.mfp != null) {
                if (debugFilter) {
                    System.out.println("read variable filtered " + v2.getFullName() + " vinfo = " + vinfo);
                }
                assert (vinfo.isChunked);
                ByteOrder bo = vinfo.typeInfo.endian;
                Section oldSection = ArraysConvert.convertSection(wantSection);
                layout = new H5tiledLayoutBB(v2, oldSection, this.raf, vinfo.mfp.getFilters(), bo);
                data = vinfo.typeInfo.isVString ? this.readFilteredStringData((LayoutBB)layout) : IospHelper.readDataFill(layout, v2.getDataType(), vinfo.getFillValue());
            } else {
                if (debug) {
                    System.out.println("read variable " + v2.getFullName() + " vinfo = " + vinfo);
                }
                DataType readDtype = v2.getDataType();
                int elemSize = v2.getElementSize();
                Object fillValue = vinfo.getFillValue();
                ByteOrder endian = vinfo.typeInfo.endian;
                wantSection = ucar.array.Section.fill(wantSection, v2.getShape());
                if (vinfo.typeInfo.hdfType == 2) {
                    readDtype = vinfo.mdt.timeType;
                    elemSize = readDtype.getSize();
                    fillValue = NetcdfFormatUtils.getFillValueDefault(readDtype);
                } else if (vinfo.typeInfo.hdfType == 8) {
                    H5header.TypeInfo baseInfo = vinfo.typeInfo.base;
                    readDtype = baseInfo.dataType;
                    elemSize = readDtype.getSize();
                    fillValue = NetcdfFormatUtils.getFillValueDefault(readDtype);
                    endian = baseInfo.endian;
                } else if (vinfo.typeInfo.hdfType == 9) {
                    elemSize = vinfo.typeInfo.byteSize;
                    endian = vinfo.typeInfo.endian;
                }
                Section oldSection = ArraysConvert.convertSection(wantSection);
                layout = vinfo.isChunked ? new H5tiledLayout((H5header.Vinfo)v2.getSPobject(), readDtype, oldSection) : new LayoutRegular(dataPos, elemSize, v2.getShape(), oldSection);
                data = this.readArrayOrPrimitive(vinfo, v2, layout, readDtype, wantSection.getShape(), fillValue, endian);
            }
            if (data instanceof ucar.array.Array) {
                return (ucar.array.Array)data;
            }
            if (dataType == ArrayType.STRUCTURE) {
                return this.makeStructureDataArray((Structure)v2, layout, wantSection.getShape(), (byte[])data);
            }
            return Arrays.factory(dataType, wantSection.getShape(), data);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
    }

    private String[] readFilteredStringData(LayoutBB layout) throws IOException {
        int size = (int)layout.getTotalNelems();
        String[] sa = new String[size];
        while (layout.hasNext()) {
            LayoutBB.Chunk chunk = layout.next();
            ByteBuffer bb = chunk.getByteBuffer();
            if (debugHeapStrings) {
                System.out.printf("readFilteredStringData chunk=%s%n", chunk);
            }
            int destPos = (int)chunk.getDestElem();
            for (int i = 0; i < chunk.getNelems(); ++i) {
                sa[destPos++] = this.header.readHeapString(bb, (chunk.getSrcElem() + i) * 16);
            }
        }
        return sa;
    }

    private Object readArrayOrPrimitive(H5header.Vinfo vinfo, Variable v, Layout layout, DataType dataType, int[] shape, Object fillValue, ByteOrder endian) throws IOException {
        H5header.TypeInfo typeInfo = vinfo.typeInfo;
        if (typeInfo.hdfType == 2) {
            Object data = IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, true);
            ucar.array.Array timeArray = Arrays.factory(dataType.getArrayType(), shape, data);
            String[] stringData = new String[(int)timeArray.length()];
            int count = 0;
            Iterator iterator = timeArray.iterator();
            while (iterator.hasNext()) {
                long time = (Long)iterator.next();
                stringData[count++] = CalendarDate.of(time).toString();
            }
            return stringData;
        }
        if (typeInfo.hdfType == 8) {
            return IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian);
        }
        if (typeInfo.isVlen) {
            return this.readVlen(dataType, shape, typeInfo, layout, endian);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.readStructureData((Structure)v, shape, layout);
        }
        if (dataType == DataType.STRING) {
            int size = (int)layout.getTotalNelems();
            String[] sa = new String[size];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    sa[count++] = this.header.readHeapString(chunk.getSrcPos() + (long)(layout.getElemSize() * i));
                }
            }
            return sa;
        }
        if (dataType == DataType.OPAQUE) {
            ArrayVlen result = ArrayVlen.factory(ArrayType.OPAQUE, shape);
            Preconditions.checkArgument((Arrays.computeSize(shape) == layout.getTotalNelems() ? 1 : 0) != 0);
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                int recsize = layout.getElemSize();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    byte[] pa = new byte[recsize];
                    this.raf.seek(chunk.getSrcPos() + (long)(i * recsize));
                    this.raf.readFully(pa, 0, recsize);
                    result.set(count++, pa);
                }
            }
            return result;
        }
        return IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, true);
    }

    private ucar.array.Array<?> readVlen(DataType dataType, int[] shape, H5header.TypeInfo typeInfo, Layout layout, ByteOrder endian) throws IOException {
        DataType readType = dataType;
        if (typeInfo.base.hdfType == 7) {
            readType = DataType.LONG;
        }
        ArrayVlen vlenArray = ArrayVlen.factory(dataType.getArrayType(), shape);
        int count = 0;
        while (layout.hasNext()) {
            Layout.Chunk chunk = layout.next();
            if (chunk == null) continue;
            for (int i = 0; i < chunk.getNelems(); ++i) {
                long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                String[] refArray = this.readHeapPrimitiveArray(address, readType, endian);
                vlenArray.set(count, typeInfo.base.hdfType == 7 ? this.convertReferenceArray((long[])refArray) : refArray);
                ++count;
            }
        }
        if (vlenArray.length() == 1L) {
            return vlenArray.get(new int[0]);
        }
        return vlenArray;
    }

    private String[] convertReferenceArray(long[] refArray) throws IOException {
        int nelems = refArray.length;
        String[] result = new String[nelems];
        int count = 0;
        for (long reference : refArray) {
            String name = this.header.getDataObjectName(reference);
            result[count++] = name != null ? name : Long.toString(reference);
        }
        return result;
    }

    private Object readHeapPrimitiveArray(long globalHeapIdAddress, DataType dataType, ByteOrder endian) throws IOException {
        H5objects.GlobalHeap.HeapObject ho;
        H5objects.HeapIdentifier heapId = this.header.h5objects.readHeapIdentifier(globalHeapIdAddress);
        if (debugHeap) {
            log.debug(" heapId= {}", (Object)heapId);
        }
        if ((ho = heapId.getHeapObject()) == null) {
            throw new IllegalStateException("Illegal Heap address, HeapObject = " + heapId);
        }
        if (debugHeap) {
            log.debug(" HeapObject= {}", (Object)ho);
        }
        if (endian != null) {
            this.raf.order(endian);
        }
        if (DataType.FLOAT == dataType) {
            float[] pa = new float[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFloat(pa, 0, pa.length);
            return pa;
        }
        if (DataType.DOUBLE == dataType) {
            double[] pa = new double[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readDouble(pa, 0, pa.length);
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            byte[] pa = new byte[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFully(pa, 0, pa.length);
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = new short[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readShort(pa, 0, pa.length);
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = new int[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readInt(pa, 0, pa.length);
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = new long[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readLong(pa, 0, pa.length);
            return pa;
        }
        throw new UnsupportedOperationException("getHeapPrimitiveArray dataType=" + (Object)((Object)dataType));
    }

    private ucar.array.Array<?> readStructureData(Structure v, int[] shape, Layout layout) throws IOException {
        int recsize = layout.getElemSize();
        long size = (long)recsize * layout.getTotalNelems();
        byte[] byteArray = new byte[(int)size];
        while (layout.hasNext()) {
            Layout.Chunk chunk = layout.next();
            if (chunk == null) continue;
            if (debugStructure) {
                System.out.println(" readStructure " + v.getFullName() + " chunk= " + chunk + " index.getElemSize= " + layout.getElemSize());
            }
            this.raf.seek(chunk.getSrcPos());
            this.raf.readFully(byteArray, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
        }
        return this.makeStructureDataArray(v, layout, shape, byteArray);
    }

    private ucar.array.Array<StructureData> makeStructureDataArray(Structure s, Layout layout, int[] shape, byte[] byteArray) throws IOException {
        StructureMembers.Builder mb = s.makeStructureMembersBuilder();
        boolean hasHeap = this.augmentStructureMembers(s, mb);
        int recSize = layout.getElemSize();
        mb.setStructureSize(recSize);
        StructureMembers sm = mb.build();
        if (recSize != sm.getStorageSizeBytes()) {
            log.error("calcSize = {} actualSize = {}%n", (Object)sm.getStorageSizeBytes(), (Object)recSize);
            throw new IOException("H5iosp illegal structure size " + s.getFullName());
        }
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        StructureDataStorageBB storage = new StructureDataStorageBB(sm, ByteBuffer.wrap(byteArray), (int)Arrays.computeSize(shape));
        if (hasHeap) {
            int destPos = 0;
            int i = 0;
            while ((long)i < layout.getTotalNelems()) {
                this.readHeapData(bb, storage, destPos, sm);
                destPos += layout.getElemSize();
                ++i;
            }
        }
        return new StructureDataArray(sm, shape, (Storage<StructureData>)storage);
    }

    private boolean augmentStructureMembers(Structure s, StructureMembers.Builder sm) {
        boolean hasHeap = false;
        for (StructureMembers.MemberBuilder mb : sm.getStructureMembers()) {
            Variable v2 = s.findVariable(mb.getName());
            assert (v2 != null);
            H5header.Vinfo vm = (H5header.Vinfo)v2.getSPobject();
            if (vm.typeInfo.endian != null) {
                mb.setByteOrder(vm.typeInfo.endian);
            }
            mb.setOffset((int)vm.dataPos);
            if (v2.getDataType() == DataType.STRING || v2.isVariableLength()) {
                hasHeap = true;
            }
            if (!(v2 instanceof Structure)) continue;
            Structure nested = (Structure)v2;
            StructureMembers.Builder nestSm = mb.getStructureMembers();
            hasHeap |= this.augmentStructureMembers(nested, nestSm);
        }
        return hasHeap;
    }

    private void readHeapData(ByteBuffer bb, StructureDataStorageBB storage, int pos, StructureMembers sm) throws IOException {
        for (StructureMembers.Member m : sm.getMembers()) {
            if (m.getArrayType() == ArrayType.STRING) {
                int size = m.length();
                int destPos = pos + m.getOffset();
                String[] result = new String[size];
                for (int i = 0; i < size; ++i) {
                    result[i] = this.header.readHeapString(bb, destPos + i * 16);
                }
                int index = storage.putOnHeap(result);
                bb.order(m.getByteOrder());
                bb.putInt(destPos, index);
                continue;
            }
            if (!m.isVlen()) continue;
            int startPos = pos + m.getOffset();
            bb.order(ByteOrder.LITTLE_ENDIAN);
            ByteOrder endian = m.getByteOrder();
            ArrayVlen vlenArray = ArrayVlen.factory(m.getArrayType(), m.getShape());
            int size = (int)Arrays.computeSize(vlenArray.getShape());
            Preconditions.checkArgument((size == m.length() ? 1 : 0) != 0, (Object)"Internal error: field size mismatch");
            int readPos = startPos;
            for (int i = 0; i < size; ++i) {
                Array vlen = this.header.readHeapVlen(bb, readPos, m.getArrayType().getDataType(), endian);
                vlenArray.set(i, vlen.get1DJavaArray(m.getArrayType().getDataType()));
                readPos += 16;
            }
            int index = storage.putOnHeap(vlenArray);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(startPos, index);
        }
    }
}

