/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.internal.iosp.hdf5.H5header;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutTiled;

@Immutable
public class H5tiledLayout
implements Layout {
    private static final boolean debug = false;
    private final LayoutTiled delegate;
    private final Section want;
    private final int[] chunkSize;
    private final int elemSize;

    public H5tiledLayout(H5header.Vinfo vinfo, DataType dtype, Section wantSection) throws IOException {
        assert (vinfo.isChunked);
        assert (vinfo.btree != null);
        this.want = dtype == DataType.CHAR && wantSection.getRank() < vinfo.storageSize.length ? Section.builder().appendRanges(wantSection.getRanges()).appendRange(1).build() : wantSection;
        int nChunkDims = dtype == DataType.CHAR ? vinfo.storageSize.length : vinfo.storageSize.length - 1;
        this.chunkSize = new int[nChunkDims];
        System.arraycopy(vinfo.storageSize, 0, this.chunkSize, 0, nChunkDims);
        this.elemSize = vinfo.storageSize[vinfo.storageSize.length - 1];
        LayoutTiled.DataChunkIterator iter = vinfo.btree.getDataChunkIteratorNoFilter(this.want, nChunkDims);
        this.delegate = new LayoutTiled(iter, this.chunkSize, this.elemSize, this.want);
    }

    @Override
    public long getTotalNelems() {
        return this.delegate.getTotalNelems();
    }

    @Override
    public int getElemSize() {
        return this.delegate.getElemSize();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public Layout.Chunk next() {
        return this.delegate.next();
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.getTotalNelems());
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }
}

