/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.hdf5.DataBTree;
import ucar.nc2.internal.iosp.hdf5.H5header;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.internal.iosp.hdf5.H5objects;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutBBTiled;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class H5tiledLayoutBB
implements LayoutBB {
    static boolean debugFilter;
    private static final int DEFAULTZIPBUFFERSIZE = 512;
    private static final String INFLATEBUFFERSIZE_PROPERTY = "unidata.h5iosp.inflate.buffersize";
    private static boolean debug;
    private final LayoutBBTiled delegate;
    private final RandomAccessFile raf;
    private final H5objects.Filter[] filters;
    private final ByteOrder byteOrder;
    private final Section want;
    private final int[] chunkSize;
    private final int elemSize;
    private final int nChunkDims;
    private int inflatebuffersize = 512;

    public H5tiledLayoutBB(Variable v2, Section wantSection, RandomAccessFile raf, H5objects.Filter[] filters, ByteOrder byteOrder) throws InvalidRangeException, IOException {
        wantSection = Section.fill(wantSection, v2.getShape());
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        Preconditions.checkNotNull((Object)vinfo);
        Preconditions.checkArgument((boolean)vinfo.isChunked);
        Preconditions.checkNotNull((Object)vinfo.btree);
        this.raf = raf;
        this.filters = filters;
        this.byteOrder = byteOrder;
        DataType dtype = v2.getDataType();
        this.want = dtype == DataType.CHAR && wantSection.getRank() < vinfo.storageSize.length ? Section.builder().appendRanges(wantSection.getRanges()).appendRange(1).build() : wantSection;
        this.nChunkDims = dtype == DataType.CHAR ? vinfo.storageSize.length : vinfo.storageSize.length - 1;
        this.chunkSize = new int[this.nChunkDims];
        System.arraycopy(vinfo.storageSize, 0, this.chunkSize, 0, this.nChunkDims);
        this.elemSize = vinfo.storageSize[vinfo.storageSize.length - 1];
        DataBTree.DataChunkIterator iter = vinfo.btree.getDataChunkIteratorFilter(this.want);
        DataChunkIterator dcIter = new DataChunkIterator(iter);
        this.delegate = new LayoutBBTiled(dcIter, this.chunkSize, this.elemSize, this.want);
        if (System.getProperty(INFLATEBUFFERSIZE_PROPERTY) != null) {
            try {
                int size = Integer.parseInt(System.getProperty(INFLATEBUFFERSIZE_PROPERTY));
                if (size <= 0) {
                    H5iosp.log.warn(String.format("-D%s must be > 0", INFLATEBUFFERSIZE_PROPERTY));
                } else {
                    this.inflatebuffersize = size;
                }
            }
            catch (NumberFormatException nfe) {
                H5iosp.log.warn(String.format("-D%s is not an integer", INFLATEBUFFERSIZE_PROPERTY));
            }
        }
        if (debugFilter) {
            System.out.printf("inflate buffer size -D%s = %d%n", INFLATEBUFFERSIZE_PROPERTY, this.inflatebuffersize);
        }
        if (debug) {
            System.out.println(" H5tiledLayout: " + this);
        }
    }

    @Override
    public long getTotalNelems() {
        return this.delegate.getTotalNelems();
    }

    @Override
    public int getElemSize() {
        return this.delegate.getElemSize();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public LayoutBB.Chunk next() {
        return this.delegate.next();
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.getTotalNelems());
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }

    private class DataChunk
    implements LayoutBBTiled.DataChunk {
        private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
        DataBTree.DataChunk delegate;

        DataChunk(DataBTree.DataChunk delegate) {
            this.delegate = delegate;
            if (delegate.size < 0 || delegate.size > 0x7FFFFFF7) {
                byte[] intBytes = Ints.toByteArray((int)delegate.size);
                byte[] longBytes = new byte[8];
                System.arraycopy(intBytes, 0, longBytes, 4, 4);
                long chunkSize = Longs.fromByteArray((byte[])longBytes);
                throw new IllegalArgumentException(String.format("Filtered data chunk is %s bytes and we must load it all into memory. However the maximum length of a byte array in Java is %s.", chunkSize, 0x7FFFFFF7));
            }
        }

        @Override
        public int[] getOffset() {
            int[] offset = this.delegate.offset;
            if (offset.length > H5tiledLayoutBB.this.nChunkDims) {
                offset = new int[H5tiledLayoutBB.this.nChunkDims];
                System.arraycopy(this.delegate.offset, 0, offset, 0, H5tiledLayoutBB.this.nChunkDims);
            }
            return offset;
        }

        @Override
        public ByteBuffer getByteBuffer() throws IOException {
            try {
                byte[] data = new byte[this.delegate.size];
                H5tiledLayoutBB.this.raf.seek(this.delegate.filePos);
                H5tiledLayoutBB.this.raf.readFully(data);
                for (int i = H5tiledLayoutBB.this.filters.length - 1; i >= 0; --i) {
                    H5objects.Filter f = H5tiledLayoutBB.this.filters[i];
                    if (this.isBitSet(this.delegate.filterMask, i)) {
                        if (!debug) continue;
                        System.out.println("skip for chunk " + this.delegate);
                        continue;
                    }
                    if (f.id == 1) {
                        data = this.inflate(data);
                        continue;
                    }
                    if (f.id == 2) {
                        data = this.shuffle(data, f.data[0]);
                        continue;
                    }
                    if (f.id == 3) {
                        data = this.checkfletcher32(data);
                        continue;
                    }
                    throw new RuntimeException("Unknown filter type=" + f.id);
                }
                ByteBuffer result = ByteBuffer.wrap(data);
                result.order(H5tiledLayoutBB.this.byteOrder);
                return result;
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryError oom = new OutOfMemoryError("Ran out of memory trying to read HDF5 filtered chunk. Either increase the JVM's heap size (use the -Xmx switch) or reduce the size of the dataset's chunks (use nccopy -c).");
                oom.initCause(e);
                throw oom;
            }
        }

        private byte[] inflate(byte[] compressed) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            Inflater inflater = new Inflater();
            InflaterInputStream inflatestream = new InflaterInputStream(in, inflater, H5tiledLayoutBB.this.inflatebuffersize);
            int len = Math.min(8 * compressed.length, 0x7FFFFFF7);
            ByteArrayOutputStream out = new ByteArrayOutputStream(len);
            IO.copyB(inflatestream, out, len);
            byte[] uncomp = out.toByteArray();
            if (debug || debugFilter) {
                System.out.println(" inflate bytes in= " + compressed.length + " bytes out= " + uncomp.length);
            }
            return uncomp;
        }

        private byte[] checkfletcher32(byte[] org) {
            byte[] result = new byte[org.length - 4];
            System.arraycopy(org, 0, result, 0, result.length);
            if (debug) {
                System.out.println(" checkfletcher32 bytes in= " + org.length + " bytes out= " + result.length);
            }
            return result;
        }

        private byte[] shuffle(byte[] data, int n) {
            if (debug) {
                System.out.println(" shuffle bytes in= " + data.length + " n= " + n);
            }
            assert (data.length % n == 0);
            if (n <= 1) {
                return data;
            }
            int m = data.length / n;
            int[] count = new int[n];
            for (int k = 0; k < n; ++k) {
                count[k] = k * m;
            }
            byte[] result = new byte[data.length];
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    result[i * n + j] = data[i + count[j]];
                }
            }
            return result;
        }

        boolean isBitSet(int val, int bitno) {
            return (val >>> bitno & 1) != 0;
        }
    }

    private class DataChunkIterator
    implements LayoutBBTiled.DataChunkIterator {
        DataBTree.DataChunkIterator delegate;

        DataChunkIterator(DataBTree.DataChunkIterator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public LayoutBBTiled.DataChunk next() throws IOException {
            return new DataChunk(this.delegate.next());
        }
    }
}

