/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import java.util.Formatter;

public class Tiling {
    private final int rank;
    private final int[] shape;
    private final int[] chunk;
    private final int[] stride;

    public Tiling(int[] shape, int[] chunk) {
        assert (shape.length <= chunk.length);
        this.rank = shape.length;
        this.chunk = chunk;
        this.shape = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.shape[i] = Math.max(shape[i], chunk[i]);
        }
        int[] tileSize = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            tileSize[i] = (this.shape[i] + chunk[i] - 1) / chunk[i];
        }
        this.stride = new int[this.rank];
        int strider = 1;
        for (int k = this.rank - 1; k >= 0; --k) {
            this.stride[k] = strider;
            strider *= tileSize[k];
        }
    }

    String show(int[] a) {
        Formatter f = new Formatter();
        for (int val : a) {
            f.format("%3d,", val);
        }
        return f.toString();
    }

    public int[] tile(int[] pt) {
        int useRank = Math.min(this.rank, pt.length);
        int[] tile = new int[useRank];
        for (int i = 0; i < useRank; ++i) {
            tile[i] = pt[i] / this.chunk[i];
        }
        return tile;
    }

    public int order(int[] pt) {
        int[] tile = this.tile(pt);
        int order = 0;
        int useRank = Math.min(this.rank, pt.length);
        for (int i = 0; i < useRank; ++i) {
            order += this.stride[i] * tile[i];
        }
        return order;
    }

    public int compare(int[] p1, int[] p2) {
        return this.order(p1) - this.order(p2);
    }
}

