/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3header;
import ucar.nc2.internal.iosp.netcdf3.N3iosp;
import ucar.nc2.write.UnlimitedDimension;
import ucar.unidata.io.RandomAccessFile;

class N3headerWriter
extends N3header {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private Group rootGroup;
    private long globalAttsPos;
    private UnlimitedDimension unlimitedDim;

    N3headerWriter(N3iosp n3iospNew, RandomAccessFile raf) {
        super(n3iospNew);
        this.raf = raf;
    }

    void initFromExisting(N3iosp existingIosp, Group.Builder rootb) {
        N3header existingHeader = existingIosp.header;
        this.dataStart = existingHeader.dataStart;
        this.nonRecordDataSize = existingHeader.nonRecordDataSize;
        this.numrecs = existingHeader.numrecs;
        this.recsize = existingHeader.recsize;
        this.recStart = existingHeader.recStart;
        this.useLongOffset = existingHeader.useLongOffset;
        if (existingHeader.udim != null) {
            this.unlimitedDim = new UnlimitedDimension(existingHeader.udim.getShortName(), existingHeader.udim.getLength());
            this.udim = this.unlimitedDim;
            if (!rootb.replaceDimension(this.unlimitedDim)) {
                throw new IllegalStateException();
            }
            for (Variable.Builder<?> vb : rootb.vbuilders) {
                if (!vb.isUnlimited() || vb.replaceDimensionByName(this.unlimitedDim)) continue;
                throw new IllegalStateException();
            }
        }
    }

    void create(Group.Builder rootGroup, int extra, boolean largeFile) throws IOException {
        this.writeHeader(rootGroup, extra, largeFile, false);
    }

    void setRootGroup(Group rootGroup) {
        this.rootGroup = rootGroup;
    }

    boolean rewriteHeader(boolean largeFile) throws IOException {
        int want = this.sizeHeader(largeFile);
        return (long)want <= this.dataStart;
    }

    void writeHeader(Group.Builder rootGroup, int extra, boolean largeFile, boolean keepDataStart) throws IOException {
        N3header.Vinfo vinfo;
        this.useLongOffset = largeFile;
        this.nonRecordDataSize = 0L;
        this.recsize = 0L;
        this.recStart = Long.MAX_VALUE;
        this.raf.seek(0L);
        this.raf.write(largeFile ? N3header.MAGIC_LONG : N3header.MAGIC);
        this.raf.writeInt(0);
        Iterable<Dimension> dims = rootGroup.getDimensions();
        int numdims = Iterables.size(dims);
        if (numdims == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(10);
            this.raf.writeInt(numdims);
        }
        for (Dimension dimension : dims) {
            this.writeString(dimension.getShortName());
            this.raf.writeInt(dimension.isUnlimited() ? 0 : dimension.getLength());
            if (!dimension.isUnlimited()) continue;
            this.udim = dimension;
            this.unlimitedDim = dimension instanceof UnlimitedDimension ? (UnlimitedDimension)dimension : new UnlimitedDimension(dimension.getShortName(), dimension.getLength());
        }
        this.globalAttsPos = this.raf.getFilePointer();
        this.writeAtts(rootGroup.getAttributeContainer());
        ArrayList uvarb = new ArrayList();
        for (Variable.Builder<?> builder : rootGroup.vbuilders) {
            if (!builder.isUnlimited()) continue;
            uvarb.add(builder);
        }
        this.writeVars(rootGroup, uvarb, largeFile);
        if (!keepDataStart) {
            this.dataStart = this.raf.getFilePointer();
            if (extra > 0) {
                this.dataStart += (long)extra;
            }
        }
        long l = this.dataStart;
        for (Variable.Builder<?> var : rootGroup.vbuilders) {
            vinfo = (N3header.Vinfo)var.spiObject;
            if (vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(l);
            } else {
                if (l > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Variable starting pos=" + l + " may not exceed " + Integer.MAX_VALUE);
                }
                this.raf.writeInt((int)l);
            }
            vinfo.begin = l;
            l += vinfo.vsize;
            this.nonRecordDataSize = Math.max(this.nonRecordDataSize, vinfo.begin + vinfo.vsize);
        }
        this.recStart = l;
        for (Variable.Builder<?> var : rootGroup.vbuilders) {
            vinfo = (N3header.Vinfo)var.spiObject;
            if (!vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(l);
            } else {
                this.raf.writeInt((int)l);
            }
            vinfo.begin = l;
            l += vinfo.vsize;
            this.recsize += vinfo.vsize;
            this.recStart = Math.min(this.recStart, vinfo.begin);
        }
        if (this.nonRecordDataSize > 0L) {
            this.nonRecordDataSize -= this.dataStart;
        }
        if (uvarb.isEmpty()) {
            this.recStart = 0L;
        }
    }

    int sizeHeader(boolean largeFile) {
        int size = 4;
        size += 4;
        size += 8;
        for (Dimension dim : this.rootGroup.getDimensions()) {
            size += this.sizeString(dim.getShortName()) + 4;
        }
        size += this.sizeAtts(this.rootGroup.attributes());
        size += 8;
        for (Variable var : this.rootGroup.getVariables()) {
            size += this.sizeString(var.getShortName());
            size += 4;
            size += 4 * var.getDimensions().size();
            size += this.sizeAtts(var.attributes());
            size += 8;
            size += largeFile ? 8 : 4;
        }
        return size;
    }

    private void writeAtts(Iterable<Attribute> atts) throws IOException {
        int n = Iterables.size(atts);
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(12);
            this.raf.writeInt(n);
        }
        boolean count = false;
        for (Attribute att : atts) {
            this.writeString(att.getShortName());
            int type = N3headerWriter.getType(att.getDataType());
            this.raf.writeInt(type);
            if (type == 2) {
                this.writeStringValues(att);
                continue;
            }
            int nelems = att.getLength();
            this.raf.writeInt(nelems);
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.writeAttributeValue(att.getNumericValue(j));
            }
            this.pad(nbytes, (byte)0);
        }
    }

    private int sizeAtts(Iterable<Attribute> atts) {
        int size = 8;
        for (Attribute att : atts) {
            size += this.sizeString(att.getShortName());
            size += 4;
            int type = N3headerWriter.getType(att.getDataType());
            if (type == 2) {
                size += this.sizeStringValues(att);
                continue;
            }
            size += 4;
            int nelems = att.getLength();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.sizeAttributeValue(att.getNumericValue(j));
            }
            size += nbytes;
            size += N3headerWriter.padding(nbytes);
        }
        return size;
    }

    private void writeStringValues(Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            this.writeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            this.writeString(values.toString());
        }
    }

    private int sizeStringValues(Attribute att) {
        int size = 0;
        int n = att.getLength();
        if (n == 1) {
            size += this.sizeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            size += this.sizeString(values.toString());
        }
        return size;
    }

    private int writeAttributeValue(Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            this.raf.write(numValue.byteValue());
            return 1;
        }
        if (numValue instanceof Short) {
            this.raf.writeShort(numValue.shortValue());
            return 2;
        }
        if (numValue instanceof Integer) {
            this.raf.writeInt(numValue.intValue());
            return 4;
        }
        if (numValue instanceof Float) {
            this.raf.writeFloat(numValue.floatValue());
            return 4;
        }
        if (numValue instanceof Double) {
            this.raf.writeDouble(numValue.doubleValue());
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int sizeAttributeValue(Number numValue) {
        if (numValue instanceof Byte) {
            return 1;
        }
        if (numValue instanceof Short) {
            return 2;
        }
        if (numValue instanceof Integer) {
            return 4;
        }
        if (numValue instanceof Float) {
            return 4;
        }
        if (numValue instanceof Double) {
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private void writeVars(Group.Builder rootGroup, ArrayList<Variable.Builder<?>> uvarb, boolean largeFile) throws IOException {
        int n = rootGroup.vbuilders.size();
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(11);
            this.raf.writeInt(n);
        }
        for (Variable.Builder<?> var : rootGroup.vbuilders) {
            this.writeString(var.shortName);
            long vsize = var.dataType.getSize();
            ImmutableList<Dimension> dims = var.getDimensions();
            this.raf.writeInt(dims.size());
            for (Dimension dim : dims) {
                int dimIndex = this.findDimensionIndex(rootGroup, dim);
                this.raf.writeInt(dimIndex);
                if (dim.isUnlimited()) continue;
                vsize *= (long)dim.getLength();
            }
            long unpaddedVsize = vsize;
            vsize += (long)N3headerWriter.padding(vsize);
            long varAttsPos = this.raf.getFilePointer();
            this.writeAtts(var.getAttributeContainer());
            DataType dtype = var.dataType.getDataType();
            int type = N3headerWriter.getType(dtype);
            this.raf.writeInt(type);
            int vsizeWrite = vsize < 0xFFFFFFFFL ? (int)vsize : -1;
            this.raf.writeInt(vsizeWrite);
            long pos = this.raf.getFilePointer();
            if (largeFile) {
                this.raf.writeLong(0L);
            } else {
                this.raf.writeInt(0);
            }
            if (uvarb.size() == 1 && uvarb.get(0) == var && (dtype == DataType.CHAR || dtype == DataType.BYTE || dtype == DataType.SHORT)) {
                vsize = unpaddedVsize;
            }
            var.setSPobject(new N3header.Vinfo(var.shortName, vsize, pos, var.isUnlimited(), varAttsPos));
        }
    }

    private void writeString(String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.raf.writeInt(b.length);
        this.raf.write(b);
        this.pad(b.length, (byte)0);
    }

    private int sizeString(String s) {
        int size = s.length() + 4;
        return size + N3headerWriter.padding(s.length());
    }

    private int findDimensionIndex(Group.Builder rootGroup, Dimension wantDim) {
        int count = 0;
        for (Dimension dim : rootGroup.getDimensions()) {
            if (dim.equals(wantDim)) {
                return count;
            }
            ++count;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private void pad(int nbytes, byte fill) throws IOException {
        int pad = N3headerWriter.padding(nbytes);
        for (int i = 0; i < pad; ++i) {
            this.raf.write(fill);
        }
    }

    void writeNumrecs() throws IOException {
        this.raf.seek(4L);
        this.raf.writeInt(this.numrecs);
    }

    void setNumrecs(int n) {
        this.numrecs = n;
        this.unlimitedDim.setLength(n);
    }

    void updateAttribute(Variable v2, Attribute att) throws IOException {
        long pos;
        if (v2 == null) {
            pos = this.findAtt(this.globalAttsPos, att.getShortName());
        } else {
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            pos = this.findAtt(vinfo.attsPos, att.getShortName());
        }
        this.raf.seek(pos);
        int type = this.raf.readInt();
        DataType have = N3headerWriter.getDataType(type);
        DataType want = att.getDataType();
        if (want == DataType.STRING) {
            want = DataType.CHAR;
        }
        if (want != have) {
            throw new IllegalArgumentException("Update Attribute must have same type or original = " + (Object)((Object)have) + " att = " + att);
        }
        if (type == 2) {
            String s = att.getStringValue();
            int org = this.raf.readInt();
            int size = org + N3headerWriter.padding(org);
            int max = Math.min(size, s.length());
            if (max > org) {
                this.raf.seek(pos + 4L);
                this.raf.writeInt(max);
            }
            byte[] b = new byte[size];
            for (int i = 0; i < max; ++i) {
                b[i] = (byte)s.charAt(i);
            }
            this.raf.write(b);
        } else {
            int nelems = this.raf.readInt();
            int max = Math.min(nelems, att.getLength());
            for (int j = 0; j < max; ++j) {
                this.writeAttributeValue(att.getNumericValue(j));
            }
        }
    }

    private long findAtt(long start_pos, String want) throws IOException {
        this.raf.seek(start_pos + 4L);
        int natts = this.raf.readInt();
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            if (name.equals(want)) {
                return this.raf.getFilePointer();
            }
            int type = this.raf.readInt();
            if (type == 2) {
                this.readString();
                continue;
            }
            int nelems = this.raf.readInt();
            DataType dtype = N3headerWriter.getDataType(type);
            int[] shape = new int[]{nelems};
            Array arr = Array.factory(dtype, shape);
            IndexIterator ii = arr.getIndexIterator();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.readAttributeValue(dtype, ii);
            }
            this.skip(nbytes);
        }
        throw new IllegalArgumentException("no such attribute " + want);
    }
}

