/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.ArraysConvert;
import ucar.array.InvalidRangeException;
import ucar.array.Storage;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.internal.iosp.netcdf3.N3header;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutRegularSegmented;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class N3iosp
extends AbstractIOServiceProvider
implements IOServiceProvider {
    protected static Logger log = LoggerFactory.getLogger(N3iosp.class);
    protected N3header header;
    protected long lastModified;
    private final boolean debugRecord = false;
    private Charset valueCharset;
    boolean useRecordStructure;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return N3header.isValidFile(raf);
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        try {
            this.header.showDetail(f);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return f.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            if (this.header != null) {
                long size = this.header.calcFileSize();
                this.raf.setMinLength(size);
            }
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void reacquire() throws IOException {
        super.reacquire();
        this.header.raf = this.raf;
    }

    @Override
    public String toStringDebug(Object o) {
        return null;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message instanceof Charset) {
            this.setValueCharset((Charset)message);
            return Boolean.TRUE;
        }
        if (message == "AddRecordStructure") {
            this.useRecordStructure = true;
            return Boolean.TRUE;
        }
        if (message.equals("NetcdfFileFormat")) {
            return this.header.useLongOffset ? NetcdfFileFormat.NETCDF3_64BIT_OFFSET : NetcdfFileFormat.NETCDF3;
        }
        return super.sendIospMessage(message);
    }

    Optional<Charset> getValueCharset() {
        return Optional.ofNullable(this.valueCharset);
    }

    private void setValueCharset(@Nullable Charset charset) {
        this.valueCharset = charset;
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.NETCDF.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "NetCDF-3/CDM";
    }

    @Override
    public String getFileTypeVersion() {
        return "1";
    }

    @Override
    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        File file;
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = this.createHeader();
        this.header.read(raf, rootGroup, null);
    }

    private N3header createHeader() {
        return new N3header(this);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, ucar.ma2.InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readStructureData((Structure)v2, section);
        }
        Object data = this.readDataObject(v2, section);
        return Array.factory(v2.getDataType(), section.getShape(), data);
    }

    @Override
    public ucar.array.Array<?> readArrayData(Variable v2, ucar.array.Section section) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readStructureDataArray((Structure)v2, section);
        }
        try {
            Section oldSection = ArraysConvert.convertSection(section);
            Object data = this.readDataObject(v2, oldSection);
            if (v2.getArrayType() == ArrayType.CHAR) {
                data = ArraysConvert.convertCharToByte((char[])data);
            }
            return Arrays.factory(v2.getArrayType(), section.getShape(), data);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
    }

    private Object readDataObject(Variable v2, Section section) throws IOException, ucar.ma2.InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        return IospHelper.readDataFill(this.raf, layout, dataType, null, null);
    }

    private Array readStructureData(Structure s, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        StructureMembers members = s.makeStructureMembers();
        for (StructureMembers.Member m : members.getMembers()) {
            Variable v2 = s.findVariable(m.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m.setDataParam((int)(vinfo.begin - this.header.recStart));
        }
        if (this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cant read records when recsize > 2147483647");
        }
        long nrecs = section.computeSize();
        if (nrecs * this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large read: nrecs * recsize= " + nrecs * this.header.recsize + "bytes exceeds " + Integer.MAX_VALUE);
        }
        members.setStructureSize((int)this.header.recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, new int[]{recordRange.length()});
        byte[] result = structureArray.getByteBuffer().array();
        int count = 0;
        for (int recnum : recordRange) {
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            if (recnum != this.header.numrecs - 1) {
                this.raf.readFully(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            } else {
                this.raf.read(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            }
            ++count;
        }
        return structureArray;
    }

    private ucar.array.Array<StructureData> readStructureDataArray(Structure s, ucar.array.Section section) throws IOException {
        Preconditions.checkArgument((section.getRank() == 1 ? 1 : 0) != 0);
        ucar.array.Range recordRange = section.getRange(0);
        StructureMembers.Builder membersb = s.makeStructureMembersBuilder();
        for (StructureMembers.MemberBuilder m : membersb.getStructureMembers()) {
            Variable v2 = s.findVariable(m.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m.setOffset((int)(vinfo.begin - this.header.recStart));
        }
        if (this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cant read records when recsize > 2147483647");
        }
        long nrecs = section.computeSize();
        if (nrecs * this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large read: nrecs * recsize= " + nrecs * this.header.recsize + " bytes exceeds " + Integer.MAX_VALUE);
        }
        membersb.setStructureSize((int)this.header.recsize);
        byte[] result = new byte[(int)(nrecs * this.header.recsize)];
        int rcount = 0;
        for (int recnum : recordRange) {
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            if (recnum != this.header.numrecs - 1) {
                this.raf.readFully(result, (int)((long)rcount * this.header.recsize), (int)this.header.recsize);
            } else {
                this.raf.read(result, (int)((long)rcount * this.header.recsize), (int)this.header.recsize);
            }
            ++rcount;
        }
        ucar.array.StructureMembers members = membersb.build();
        StructureDataStorageBB storage = new StructureDataStorageBB(members, ByteBuffer.wrap(result), (int)section.computeSize());
        return new StructureDataArray(members, section.getShape(), (Storage<StructureData>)storage);
    }
}

