/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.util.CancelTask;

@Immutable
public class AggProxyReader
implements ProxyReader {
    private final AggDataset dataset;

    AggProxyReader(AggDataset dataset) {
        this.dataset = dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array reallyRead(Variable mainV, CancelTask cancelTask) throws IOException {
        NetcdfFile ncfile = null;
        try {
            ncfile = this.dataset.acquireFile(cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                Array array = null;
                return array;
            }
            Variable proxyV = this.findVariable(ncfile, mainV);
            Array array = proxyV.read();
            return array;
        }
        finally {
            this.dataset.close(ncfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array reallyRead(Variable mainV, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        NetcdfFile ncfile = null;
        try {
            ncfile = this.dataset.acquireFile(cancelTask);
            Variable proxyV = this.findVariable(ncfile, mainV);
            if (cancelTask != null && cancelTask.isCancel()) {
                Array array = null;
                return array;
            }
            Array array = proxyV.read(section);
            return array;
        }
        finally {
            this.dataset.close(ncfile);
        }
    }

    protected Variable findVariable(NetcdfFile ncfile, Variable mainV) {
        Variable v = ncfile.findVariable(NetcdfFiles.makeFullName(mainV));
        if (v == null) {
            VariableEnhanced ve = (VariableEnhanced)((Object)mainV);
            v = ncfile.findVariable(ve.getOriginalName());
        }
        return v;
    }
}

