/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.util;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.StructureData;
import ucar.array.StructureMembers;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;
import ucar.nc2.internal.util.CompareNetcdf2;
import ucar.nc2.util.Misc;

public class CompareArrayToArray {
    public static boolean compareFiles(NetcdfFile arrayFile, NetcdfFile arrayFile2) throws IOException {
        Stopwatch stopwatchAll = Stopwatch.createStarted();
        Formatter errlog = new Formatter();
        boolean ok = CompareNetcdf2.compareFiles(arrayFile, arrayFile2, errlog, false, false, false);
        if (!ok) {
            System.out.printf("FAIL %s %s%n", arrayFile.getLocation(), errlog);
            return false;
        }
        for (Variable v : arrayFile.getVariables()) {
            if (v.getDataType() == DataType.SEQUENCE) {
                System.out.printf("  read sequence %s %s%n", new Object[]{v.getDataType(), v.getShortName()});
                Sequence s = (Sequence)v;
                Iterator<StructureData> orgSeq = s.iterator();
                Sequence copyv = (Sequence)arrayFile2.findVariable(v.getFullName());
                Iterator<StructureData> array = copyv.iterator();
                Formatter f = new Formatter();
                boolean ok1 = CompareArrayToArray.compareSequence(f, v.getShortName(), orgSeq, array);
                if (!ok1) {
                    System.out.printf("%s%n", f);
                }
                ok &= ok1;
                continue;
            }
            Array<?> org = v.readArray();
            Variable cdmrVar = arrayFile2.findVariable(v.getFullName());
            Array<?> array = cdmrVar.readArray();
            System.out.printf("  check %s %s%n", new Object[]{v.getDataType(), v.getNameAndDimensions()});
            Formatter f = new Formatter();
            boolean ok1 = CompareArrayToArray.compareData(f, v.getShortName(), org, array, false, true);
            if (!ok1) {
                System.out.printf("%s%n", f);
            }
            ok &= ok1;
        }
        System.out.printf("*** took %s%n", stopwatchAll.stop());
        return ok;
    }

    public static boolean compareData(String name, Array<?> org, Array<?> array) throws IOException {
        Formatter f = new Formatter();
        boolean ok = CompareArrayToArray.compareData(f, name, org, array, false, true);
        if (f.toString().isEmpty()) {
            System.out.printf("%s%n", f);
        }
        return ok;
    }

    public static boolean compareData(Formatter f, String name, Array<?> org, Array<?> array, boolean justOne, boolean testTypes) throws IOException {
        boolean ok = true;
        if (org.length() != array.length()) {
            f.format(" WARN  %s: data nelems %d !== %d%n", name, org.length(), array.length());
        }
        if (org.getArrayType() != array.getArrayType()) {
            f.format(" WARN  %s: dataType %s !== %s%n", new Object[]{name, org.getArrayType(), array.getArrayType()});
        }
        if (!Misc.compare(org.getShape(), array.getShape(), f)) {
            f.format(" WARN %s: data shape %s !== %s%n", name, Arrays.toString(org.getShape()), Arrays.toString(array.getShape()));
        }
        if (org.isVlen() != array.isVlen()) {
            f.format(" WARN %s: vlens dont match %s !~= %s%n", name, org.isVlen(), array.isVlen());
            ok = false;
        }
        if (!ok) {
            return false;
        }
        ArrayType dt = org.getArrayType();
        if (org instanceof ArrayVlen) {
            ArrayVlen orgv = (ArrayVlen)org;
            ArrayVlen arrv = (ArrayVlen)array;
            Iterator iter1 = orgv.iterator();
            Iterator iter2 = arrv.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Array v1 = iter1.next();
                Array v2 = iter2.next();
                ok &= CompareArrayToArray.compareData(f, name, v1, v2, justOne, testTypes);
            }
            return ok;
        }
        block0 : switch (dt) {
            case CHAR: 
            case OPAQUE: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v2;
                    byte v1 = (Byte)iter1.next();
                    if (v1 == (v2 = ((Byte)iter2.next()).byteValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, v1, v2, 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case DOUBLE: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    double v2;
                    double v1 = (Double)iter1.next();
                    if (Misc.nearlyEquals(v1, v2 = ((Double)iter2.next()).doubleValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, v1, v2, 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case FLOAT: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    float v2;
                    float v1 = ((Float)iter1.next()).floatValue();
                    if (Misc.nearlyEquals(v1, v2 = ((Float)iter2.next()).floatValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, Float.valueOf(v1), Float.valueOf(v2), 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    int v2;
                    int v1 = (Integer)iter1.next();
                    if (v1 == (v2 = ((Integer)iter2.next()).intValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, v1, v2, 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case LONG: 
            case ULONG: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    long v2;
                    long v1 = (Long)iter1.next();
                    if (v1 == (v2 = ((Long)iter2.next()).longValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, v1, v2, 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    short v2;
                    short v1 = (Short)iter1.next();
                    if (v1 == (v2 = ((Short)iter2.next()).shortValue())) continue;
                    f.format(CompareArrayToArray.createNumericDataDiffMessage(dt, name, v1, v2, 0), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case STRING: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    String v2;
                    String v1 = (String)iter1.next();
                    if (v1.equals(v2 = (String)iter2.next())) continue;
                    f.format(" DIFF string %s: %s != %s count=%s%n", name, v1, v2, 0);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case SEQUENCE: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                int row = 0;
                while (iter1.hasNext() && iter2.hasNext()) {
                    ok &= CompareArrayToArray.compareStructureData(f, (StructureData)iter1.next(), (StructureData)iter2.next(), justOne);
                    ++row;
                }
                break;
            }
            case STRUCTURE: {
                Iterator<?> iter1 = org.iterator();
                Iterator<?> iter2 = array.iterator();
                int row = 0;
                while (iter1.hasNext() && iter2.hasNext()) {
                    ok &= CompareArrayToArray.compareStructureData(f, (StructureData)iter1.next(), (StructureData)iter2.next(), justOne);
                    ++row;
                }
                break;
            }
            default: {
                ok = false;
                f.format(" %s: Unknown data type %s%n", new Object[]{name, org.getArrayType()});
            }
        }
        return ok;
    }

    private static String createNumericDataDiffMessage(ArrayType dt, String name, Number v1, Number v2, int idx) {
        return String.format(" DIFF %s %s: %s != %s;  count = %s, absDiff = %s, relDiff = %s %n", new Object[]{dt, name, v1, v2, idx, Misc.absoluteDifference(v1.doubleValue(), v2.doubleValue()), Misc.relativeDifference(v1.doubleValue(), v2.doubleValue())});
    }

    private static boolean compareStructureData(Formatter f, StructureData org, StructureData array, boolean justOne) throws IOException {
        boolean ok = true;
        StructureMembers sm1 = org.getStructureMembers();
        StructureMembers sm2 = array.getStructureMembers();
        if (sm1.getMembers().size() != sm2.getMembers().size()) {
            f.format(" membersize %d !== %d%n", sm1.getMembers().size(), sm2.getMembers().size());
            ok = false;
        }
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            if (m2 == null) {
                System.out.printf("Cant find %s in copy%n", m1.getName());
                continue;
            }
            Array<?> data1 = org.getMemberData(m2);
            Array<?> data2 = array.getMemberData(m2);
            if (data2 == null) continue;
            f.format("    compare member %s %s%n", new Object[]{m1.getArrayType(), m1.getName()});
            ok &= CompareArrayToArray.compareData(f, m1.getName(), data1, data2, justOne, false);
        }
        return ok;
    }

    public static boolean compareSequence(Formatter f, String name, Iterator<StructureData> org, Iterator<StructureData> array) throws IOException {
        boolean ok = true;
        int obsrow = 0;
        System.out.printf(" compareSequence %s%n", name);
        while (org.hasNext() && array.hasNext()) {
            ok &= CompareArrayToArray.compareStructureData(f, org.next(), array.next(), false);
            ++obsrow;
        }
        return ok;
    }
}

