/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.util;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.StructureData;
import ucar.array.StructureMembers;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;
import ucar.nc2.internal.util.CompareNetcdf2;
import ucar.nc2.util.Misc;

public class CompareArrayToMa2 {
    public static boolean compareFiles(NetcdfFile ma2File, NetcdfFile arrayFile) throws IOException {
        return CompareArrayToMa2.compareFiles(ma2File, arrayFile, true);
    }

    public static boolean compareFiles(NetcdfFile ma2File, NetcdfFile arrayFile, boolean justOne) throws IOException {
        Stopwatch stopwatchAll = Stopwatch.createStarted();
        Formatter errlog = new Formatter();
        boolean ok = CompareNetcdf2.compareFiles(ma2File, arrayFile, errlog, false, false, false);
        if (!ok) {
            System.out.printf("FAIL %s %s%n", arrayFile.getLocation(), errlog);
            return false;
        }
        for (Variable v : ma2File.getVariables()) {
            ok &= CompareArrayToMa2.compareVariable(ma2File, arrayFile, v.getFullName(), justOne);
        }
        System.out.printf("*** took %s%n", stopwatchAll.stop());
        return ok;
    }

    public static boolean compareVariable(NetcdfFile ma2File, NetcdfFile arrayFile, String varName, boolean justOne) throws IOException {
        Variable vorg = ma2File.findVariable(varName);
        if (vorg == null) {
            System.out.printf("  Cant find variable %s in %s%n", varName, ma2File.getLocation());
            return false;
        }
        Variable vnew = arrayFile.findVariable(varName);
        if (vnew == null) {
            System.out.printf("  Cant find variable %s in %s%n", varName, arrayFile.getLocation());
            return false;
        }
        if (vorg.getArrayType() == ArrayType.SEQUENCE) {
            System.out.printf("  read sequence %s %s%n", new Object[]{vorg.getDataType(), vorg.getShortName()});
            Sequence sorg = (Sequence)vorg;
            StructureDataIterator orgIter = sorg.getStructureIterator(-1);
            Sequence sarray = (Sequence)vnew;
            Iterator<StructureData> arrayIter = sarray.iterator();
            Formatter f = new Formatter();
            boolean ok1 = CompareArrayToMa2.compareSequence(f, vorg.getShortName(), orgIter, arrayIter);
            if (!ok1) {
                System.out.printf("%s%n", f);
                return false;
            }
        } else {
            ucar.ma2.Array org = vorg.read();
            Array<?> array = vnew.readArray();
            System.out.printf("  read variable %s %s%n", new Object[]{vorg.getDataType(), vorg.getNameAndDimensions()});
            Formatter f = new Formatter();
            boolean ok1 = CompareArrayToMa2.compareData(f, vorg.getShortName(), org, array, justOne, true);
            if (!ok1) {
                System.out.printf("%s%n", f);
                return false;
            }
        }
        return true;
    }

    public static boolean compareData(Formatter f, String name, ucar.ma2.Array org, Array<?> array, boolean justOne, boolean testTypes) throws IOException {
        boolean ok = true;
        if (org.getSize() != ((Array)array).length()) {
            f.format(" WARN  %s: data nelems %d !== %d%n", name, org.getSize(), ((Array)array).length());
        }
        if (!Misc.compare(org.getShape(), ((Array)array).getShape(), f)) {
            f.format(" WARN %s: data shape %s !== %s%n", name, Arrays.toString(org.getShape()), Arrays.toString(((Array)array).getShape()));
        }
        if (org.isVlen() != ((Array)array).isVlen()) {
            f.format(" WARN  %s: data vlen %s !== %s%n", name, org.isVlen(), ((Array)array).isVlen());
        }
        if (testTypes && org.getDataType().getArrayType() != ((Array)array).getArrayType()) {
            if (((Array)array).getArrayType().isEnum()) {
                if (org.getDataType().getArrayType().getSize() != ((Array)array).getArrayType().getSize()) {
                    f.format(" WARN %s: data type %s !== %s%n", new Object[]{name, org.getDataType(), ((Array)array).getArrayType()});
                    ok = false;
                }
            } else {
                f.format(" WARN %s: data type %s !== %s%n", new Object[]{name, org.getDataType(), ((Array)array).getArrayType()});
                ok = false;
            }
        }
        if (!ok) {
            return false;
        }
        DataType dt = org.getDataType();
        IndexIterator iter1 = org.getIndexIterator();
        if (dt != DataType.OPAQUE && (org.isVlen() || ((Array)array).isVlen())) {
            if (!org.isVlen() && array instanceof ArrayVlen && ((Array)array).length() == 1L) {
                ArrayVlen vlen = (ArrayVlen)array;
                array = vlen.get(new int[]{0});
            }
            Iterator<?> iter2 = ((Array)array).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Object v1 = iter1.getObjectNext();
                Object v2 = iter2.next();
                if (v1 instanceof ucar.ma2.Array && v2 instanceof Array) {
                    ok &= CompareArrayToMa2.compareData(f, name, (ucar.ma2.Array)v1, (Array)v2, justOne, testTypes);
                    continue;
                }
                if (v1.equals(v2)) continue;
                f.format(" DIFF %s: Vlen %s != %s %n", name, v1, v2);
                ok = false;
                if (!justOne) continue;
                break;
            }
            return ok;
        }
        block0 : switch (dt) {
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v2;
                    byte v1 = iter1.getByteNext();
                    if (v1 == (v2 = ((Byte)iter2.next()).byteValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case CHAR: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v2;
                    byte v1 = (byte)iter1.getCharNext();
                    if (v1 == (v2 = ((Byte)iter2.next()).byteValue())) continue;
                    f.format(" DIFF %s %s: %s != %s;  count = %s%n", new Object[]{dt, name, v1, v2, iter1});
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case DOUBLE: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    double v2;
                    double v1 = iter1.getDoubleNext();
                    if (Misc.nearlyEquals(v1, v2 = ((Double)iter2.next()).doubleValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case FLOAT: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    float v2;
                    float v1 = iter1.getFloatNext();
                    if (Misc.nearlyEquals(v1, v2 = ((Float)iter2.next()).floatValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, Float.valueOf(v1), Float.valueOf(v2), iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    int v2;
                    int v1 = iter1.getIntNext();
                    if (v1 == (v2 = ((Integer)iter2.next()).intValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case LONG: 
            case ULONG: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    long v2;
                    long v1 = iter1.getLongNext();
                    if (v1 == (v2 = ((Long)iter2.next()).longValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case OPAQUE: {
                Iterator<?> iter2 = ((Array)array).iterator();
                block20: while (iter1.hasNext() && iter2.hasNext()) {
                    ByteBuffer v1 = (ByteBuffer)iter1.getObjectNext();
                    v1.rewind();
                    Array v2 = (Array)iter2.next();
                    if ((long)v1.remaining() != v2.length()) {
                        f.format(" DIFF %s: opaque sizes differ %d != %d%n", name, v1.remaining(), v2.length());
                        ok = false;
                    }
                    for (int idx = 0; idx < v1.remaining() && (long)idx < v2.length(); ++idx) {
                        if (v1.get(idx) == ((Byte)v2.get(idx)).byteValue()) continue;
                        f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1.get(idx), (Number)v2.get(idx), iter1), new Object[0]);
                        ok = false;
                        if (justOne) continue block20;
                    }
                }
                break;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    short v2;
                    short v1 = iter1.getShortNext();
                    if (v1 == (v2 = ((Short)iter2.next()).shortValue())) continue;
                    f.format(CompareArrayToMa2.makeNumericDataDiffMessage(dt, name, v1, v2, iter1), new Object[0]);
                    ok = false;
                    if (!justOne) continue;
                    break block0;
                }
                break;
            }
            case STRING: {
                Iterator<?> iter2 = ((Array)array).iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    String v2;
                    String v1 = (String)iter1.getObjectNext();
                    if (v1 == null != ((v2 = (String)iter2.next()) == null)) {
                        f.format(" DIFF string %s: null %s != %s count=%s%n", name, v1 == null, v2 == null, iter1);
                        ok = false;
                    }
                    if (v1 == null || v1.equals(v2)) continue;
                    f.format(" DIFF string %s: %s != %s count=%s%n", name, v1, v2, iter1);
                    ok = false;
                }
                break;
            }
            case SEQUENCE: {
                ArraySequence orgSeq = (ArraySequence)org;
                StructureDataIterator sditer = orgSeq.getStructureDataIterator();
                Iterator<?> iter2 = ((Array)array).iterator();
                int row = 0;
                while (sditer.hasNext() && iter2.hasNext()) {
                    ok &= CompareArrayToMa2.compareStructureData(f, sditer.next(), (StructureData)iter2.next(), justOne);
                    ++row;
                }
                break;
            }
            case STRUCTURE: {
                Iterator<?> iter2 = ((Array)array).iterator();
                int row = 0;
                while (iter1.hasNext() && iter2.hasNext()) {
                    ok &= CompareArrayToMa2.compareStructureData(f, (ucar.ma2.StructureData)iter1.next(), (StructureData)iter2.next(), justOne);
                    ++row;
                }
                break;
            }
            default: {
                ok = false;
                f.format(" %s: Unknown data type %s%n", new Object[]{name, org.getDataType()});
            }
        }
        return ok;
    }

    private static String makeNumericDataDiffMessage(DataType dt, String name, Number v1, Number v2, IndexIterator iter) {
        return String.format(" DIFF %s %s: %s != %s;  count = %s, absDiff = %s, relDiff = %s %n", new Object[]{dt, name, v1, v2, iter, Misc.absoluteDifference(v1.doubleValue(), v2.doubleValue()), Misc.relativeDifference(v1.doubleValue(), v2.doubleValue())});
    }

    private static boolean compareStructureData(Formatter f, ucar.ma2.StructureData org, StructureData array, boolean justOne) throws IOException {
        boolean ok = true;
        StructureMembers sm1 = org.getStructureMembers();
        ucar.array.StructureMembers sm2 = array.getStructureMembers();
        if (sm1.getMembers().size() != sm2.getMembers().size()) {
            f.format(" membersize %d !== %d%n", sm1.getMembers().size(), sm2.getMembers().size());
            ok = false;
        }
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            if (m2 == null) {
                System.out.printf("Cant find %s in copy%n", m1.getName());
                continue;
            }
            ucar.ma2.Array data1 = org.getArray(m1);
            Array<?> data2 = array.getMemberData(m2);
            if (data2 == null) continue;
            f.format("    compare member %s %s%n", new Object[]{m1.getDataType(), m1.getName()});
            ok &= CompareArrayToMa2.compareData(f, m1.getName(), data1, data2, justOne, false);
        }
        return ok;
    }

    public static boolean compareSequence(Formatter f, String name, StructureDataIterator org, Iterator<StructureData> array) throws IOException {
        boolean ok = true;
        int obsrow = 0;
        while (org.hasNext() && array.hasNext()) {
            System.out.printf(" compareSequence %s row %d%n", name, obsrow);
            ok &= CompareArrayToMa2.compareStructureData(f, org.next(), array.next(), false);
            ++obsrow;
        }
        if (org.hasNext() != array.hasNext()) {
            System.out.printf(" mismatch length of sequense %s row %d: %s != %s%n", name, obsrow, org.hasNext(), array.hasNext());
            ok = false;
        }
        return ok;
    }
}

