/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class Counters {
    List<Counter> counters = new ArrayList<Counter>();
    Map<String, Counter> map = new HashMap<String, Counter>();

    public Counter add(String name) {
        Counter c = new Counter(name);
        this.counters.add(c);
        this.map.put(name, c);
        return c;
    }

    public void reset() {
        for (Counter c : this.counters) {
            c.reset();
        }
    }

    public void show(Formatter f) {
        for (Counter c : this.counters) {
            c.show(f);
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        this.show(f);
        return f.toString();
    }

    @Nullable
    public Counter get(String name) {
        return this.map.get(name);
    }

    public Counter count(String name, Comparable<?> value) {
        Counter counter = this.map.get(name);
        if (counter == null) {
            counter = this.add(name);
        }
        counter.count(value);
        return counter;
    }

    public void addTo(Counters sub) {
        for (Counter subC : sub.counters) {
            Counter all = this.map.get(subC.getName());
            if (all == null) {
                all = this.add(subC.getName());
            }
            all.addTo(subC);
        }
    }

    public Counters makeSubCounters() {
        Counters result = new Counters();
        for (Counter c : this.counters) {
            result.add(c.getName());
        }
        return result;
    }

    public static class Counter {
        private final String name;
        private boolean showRange;
        private Map<Comparable<?>, Integer> set = new HashMap();
        private String range;

        public Counter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Counter setShowRange(boolean showRange) {
            this.showRange = showRange;
            return this;
        }

        public void reset() {
            this.set = new HashMap();
        }

        public Counter count(Comparable<?> value) {
            this.set.merge(value, 1, Integer::sum);
            return this;
        }

        public void addTo(Counter sub) {
            for (Map.Entry<Comparable<?>, Integer> entry : sub.set.entrySet()) {
                Integer count = this.set.get(entry.getKey());
                if (count == null) {
                    count = 0;
                }
                this.set.put(entry.getKey(), count + entry.getValue());
            }
        }

        public int getUnique() {
            return this.set.size();
        }

        public Set<Comparable<?>> getValues() {
            return this.set.keySet();
        }

        public int getCount(Comparable<?> key) {
            Integer count = this.set.get(key);
            return count == null ? 0 : count;
        }

        @Nullable
        public Comparable<?> getMode() {
            if (this.set.size() == 1) {
                return this.set.keySet().iterator().next();
            }
            int max = -1;
            Comparable<?> mode = null;
            boolean same = true;
            Comparable<?> testKey = null;
            for (Map.Entry<Comparable<?>, Integer> entry : this.set.entrySet()) {
                Comparable<?> entryKey = entry.getKey();
                if (testKey != null && entryKey.compareTo(testKey) != 0) {
                    same = false;
                }
                testKey = entryKey;
                if (entry.getValue() <= max) continue;
                max = entry.getValue();
                mode = entry.getKey();
            }
            return same ? null : mode;
        }

        public int getTotal() {
            int total = 0;
            for (Map.Entry<Comparable<?>, Integer> entry : this.set.entrySet()) {
                total += entry.getValue().intValue();
            }
            return total;
        }

        public void show(Formatter f) {
            ArrayList list = new ArrayList(this.set.keySet());
            f.format("%n%s (%d)%n", this.name, list.size());
            Collections.sort(list);
            if (this.showRange) {
                int n = list.size();
                if (n == 0) {
                    f.format("none%n", new Object[0]);
                } else {
                    f.format("   %10s - %10s: count = %d%n", list.get(0), list.get(n - 1), this.getUnique());
                }
            } else {
                Object prev = null;
                for (Comparable comparable : list) {
                    int count = this.set.get(comparable);
                    boolean isHashDup = prev != null && comparable.hashCode() == prev.hashCode();
                    boolean isNameDup = prev != null && comparable.toString().equals(prev.toString());
                    f.format("  %s %10s: count = %d%n", isHashDup != isNameDup ? "*" : " ", comparable, count);
                    prev = comparable;
                }
            }
        }

        public String showRange() {
            if (this.range == null) {
                ArrayList list = new ArrayList(this.set.keySet());
                Collections.sort(list);
                int n = list.size();
                if (n == 0) {
                    return "none";
                }
                Formatter f = new Formatter();
                Comparable first = (Comparable)list.get(0);
                Comparable last = (Comparable)list.get(n - 1);
                f.format("%10s - %10s", first, last);
                this.range = f.toString();
            }
            return this.range;
        }
    }
}

