/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class EscapeStrings {
    static final String alphaNumeric = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    static final String _allowableInOGC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.!~*'()";
    private static final String _allowableInUrlQuery = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&'()*+,-./:;=?@_~";
    private static final char _URIEscape = '%';
    private static final byte blank = 32;
    private static final byte plus = 43;
    private static final byte hexa = 97;
    private static final byte hexf = 102;
    private static final byte hexA = 65;
    private static final byte hexF = 70;
    private static final byte hex0 = 48;
    private static final byte hex9 = 57;
    private static final byte ten = 10;
    private static final int sep = 46;

    public static String backslashEscape(String x, String reservedChars) {
        if (x == null) {
            return null;
        }
        if (reservedChars == null) {
            return x;
        }
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            sb.setCharAt(pos, '\\');
            sb.insert(++pos, c);
            ++pos;
        }
        return sb.toString();
    }

    public static String backslashUnescape(String x) {
        if (!x.contains("\\")) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x.length());
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (c == '\\') {
                c = x.charAt(++pos);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> tokenizeEscapedName(String escapedName) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int start = 0;
        while ((pos = escapedName.indexOf(46, pos + 1)) > 0) {
            if (escapedName.charAt(pos - 1) == '\\') continue;
            result.add(escapedName.substring(start, pos));
            start = pos + 1;
        }
        result.add(escapedName.substring(start));
        return result;
    }

    public static String backslashEscapeCDMString(String s, String toescape) {
        if (toescape == null || toescape.isEmpty()) {
            return s;
        }
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (toescape.indexOf(c) >= 0) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static int indexOf(String escapedName, char c) {
        int pos = 0;
        do {
            if ((pos = escapedName.indexOf(c, pos + 1)) > 0) continue;
            return pos;
        } while (escapedName.charAt(pos - 1) == '\\');
        return pos;
    }

    @Nullable
    public static String escapeOGC(String s) {
        return EscapeStrings.escapeString(s, _allowableInOGC);
    }

    @Nullable
    public static String escapeURLQuery(String ce) {
        return EscapeStrings.escapeString(ce, _allowableInUrlQuery);
    }

    @Nullable
    public static String escapeString(String in, String allowable) {
        return EscapeStrings.xescapeString(in, allowable, '%', false);
    }

    @Nullable
    private static String xescapeString(String in, String allowable, char esc, boolean spaceplus) {
        try {
            StringBuilder out = new StringBuilder();
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(StandardCharsets.UTF_8);
            byte[] allow8 = allowable.getBytes(StandardCharsets.UTF_8);
            for (byte b : utf8) {
                if (b == 32 && spaceplus) {
                    out.append('+');
                    continue;
                }
                boolean found = false;
                for (byte a : allow8) {
                    if (a != b) continue;
                    found = true;
                    break;
                }
                if (found) {
                    out.append((char)b);
                    continue;
                }
                String c = Integer.toHexString(b);
                out.append(esc);
                if (c.length() < 2) {
                    out.append('0');
                }
                out.append(c);
            }
            return out.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String unescapeURLQuery(String ce) {
        return EscapeStrings.unescapeString(ce);
    }

    @Nullable
    public static String unescapeString(String in) {
        return EscapeStrings.xunescapeString(in, '%', false);
    }

    @Nullable
    private static String xunescapeString(String in, char escape, boolean spaceplus) {
        try {
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(StandardCharsets.UTF_8);
            byte escape8 = (byte)escape;
            byte[] out = new byte[utf8.length];
            int index8 = 0;
            int i = 0;
            while (i < utf8.length) {
                byte b;
                if ((b = utf8[i++]) == 43 && spaceplus) {
                    out[index8++] = 32;
                } else if (b == escape8 && i + 2 <= utf8.length) {
                    b = (byte)(EscapeStrings.fromHex(utf8[i]) << 4 | EscapeStrings.fromHex(utf8[i + 1]));
                    i += 2;
                }
                out[index8++] = b;
            }
            return new String(out, 0, index8, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static byte fromHex(byte b) throws NumberFormatException {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(10 + (b - 97));
        }
        if (b >= 65 && b <= 70) {
            return (byte)(10 + (b - 65));
        }
        throw new NumberFormatException("Illegal hex character: " + b);
    }

    @Nullable
    public static String urlDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }
}

