/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.IndexLong;

public class IndexChunkerTiled {
    private final List<Dim> dimList = new ArrayList<Dim>();
    private final IndexLong dataIndex;
    private final Index resultIndex;
    private IndexChunker.Chunk chunk;
    private final int nelems;
    private final long total;
    private long done = 0L;
    private final int startDestElem;
    private final int startSrcElem;
    private static final boolean debug = false;
    private static final boolean debugMerge = false;
    private static final boolean debugDetail = false;
    private static final boolean debugNext = false;
    private static final boolean debugStartingElems = false;

    public IndexChunkerTiled(Section dataSection, Section wantSection) throws InvalidRangeException {
        Section intersect = dataSection.intersect(wantSection);
        this.total = intersect.computeSize();
        Preconditions.checkArgument((this.total > 0L ? 1 : 0) != 0);
        int varRank = intersect.getRank();
        int wantStride = 1;
        int dataStride = 1;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            Range dr = dataSection.getRange(ii);
            Range wr = wantSection.getRange(ii);
            Range ir = intersect.getRange(ii);
            this.dimList.add(new Dim(dr, wr, ir, dataStride, wantStride));
            dataStride *= dr.length();
            wantStride *= wr.length();
        }
        this.startDestElem = wantSection.offset(intersect);
        this.startSrcElem = dataSection.offset(intersect);
        if (varRank == 0) {
            this.nelems = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.nelems = innerDim.ncontigElements;
            if (innerDim.ncontigElements > 1) {
                innerDim.wantNelems = 1;
                innerDim.wantStride = innerDim.ncontigElements;
            }
        }
        int rank = this.dimList.size();
        long[] dataStrides = new long[rank];
        int[] resultStrides = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < this.dimList.size(); ++i) {
            Dim dim = this.dimList.get(i);
            dataStrides[rank - i - 1] = dim.dataStride * dim.want.stride();
            resultStrides[rank - i - 1] = dim.wantStride;
            shape[rank - i - 1] = dim.wantNelems;
        }
        this.dataIndex = new IndexLong(shape, dataStrides);
        this.resultIndex = new Index(shape, resultStrides);
        long nchunks = Index.computeSize(shape);
        assert (nchunks * (long)this.nelems == this.total);
    }

    public long getTotalNelems() {
        return this.total;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public IndexChunker.Chunk next() {
        if (this.chunk == null) {
            this.chunk = new IndexChunker.Chunk(0L, this.nelems, this.startDestElem);
        } else {
            this.dataIndex.incr();
            this.resultIndex.incr();
        }
        this.chunk.setSrcElem((long)this.startSrcElem + this.dataIndex.currentElement());
        this.chunk.setDestElem(this.startDestElem + this.resultIndex.currentElement());
        this.done += (long)this.nelems;
        return this.chunk;
    }

    public String toString() {
        Formatter f = new Formatter();
        for (Dim elem : this.dimList) {
            f.format("%s%n", elem);
        }
        return f.toString();
    }

    private static class Dim {
        Range data;
        Range want;
        Range intersect;
        int dataStride;
        int wantStride;
        int wantNelems;
        int ncontigElements;

        Dim(Range data, Range want, Range intersect, int dataStride, int wantStride) {
            this.data = data;
            this.want = want;
            this.intersect = intersect;
            this.dataStride = dataStride;
            this.wantStride = wantStride;
            this.ncontigElements = intersect.stride() == 1 ? intersect.length() : 1;
            this.wantNelems = intersect.length();
        }

        public String toString() {
            return "  data = " + this.data + " want = " + this.want + " intersect = " + this.intersect + " ncontigElements = " + this.ncontigElements;
        }
    }
}

