/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import ucar.array.ArrayType;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutBB;
import ucar.unidata.io.PositioningDataInputStream;
import ucar.unidata.io.RandomAccessFile;

public class IospArrayHelper {
    private static final boolean showLayoutTypes = false;

    public static Object readDataFill(RandomAccessFile raf, Layout index, ArrayType ArrayType2, Object fillValue, ByteOrder byteOrder) throws IOException {
        Object arr = fillValue == null ? IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2) : IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2, fillValue);
        return IospArrayHelper.readData(raf, index, ArrayType2, arr, byteOrder, true);
    }

    public static Object readDataFill(RandomAccessFile raf, Layout index, ArrayType ArrayType2, Object fillValue, ByteOrder byteOrder, boolean convertChar) throws IOException {
        Object arr = fillValue == null ? IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2) : IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2, fillValue);
        return IospArrayHelper.readData(raf, index, ArrayType2, arr, byteOrder, convertChar);
    }

    public static Object readData(RandomAccessFile raf, Layout layout, ArrayType ArrayType2, Object arr, ByteOrder byteOrder, boolean convertChar) throws IOException {
        block22: {
            block21: {
                if (ArrayType2.getPrimitiveClass() == Byte.class) break block21;
                if (ArrayType2 != ArrayType.CHAR) break block22;
            }
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFully(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (convertChar) {
                if (ArrayType2 == ArrayType.CHAR) {
                    return IospArrayHelper.convertByteToChar(pa);
                }
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Short.class) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readShort(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Integer.class) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readInt(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFloat(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readDouble(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Long.class) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readLong(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFully(pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRING) {
            int size = (int)layout.getTotalNelems();
            int elemSize = layout.getElemSize();
            StringBuilder sb = new StringBuilder(size);
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    sb.append(raf.readString(elemSize));
                }
            }
            return sb.toString();
        }
        throw new IllegalStateException("unknown type= " + (Object)((Object)ArrayType2));
    }

    public static Object readDataFill(PositioningDataInputStream is, Layout index, ArrayType ArrayType2, Object fillValue) throws IOException {
        Object arr = fillValue == null ? IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2) : IospArrayHelper.makePrimitiveArray((int)index.getTotalNelems(), ArrayType2, fillValue);
        return IospArrayHelper.readData(is, index, ArrayType2, arr);
    }

    public static Object readData(PositioningDataInputStream raf, Layout index, ArrayType ArrayType2, Object arr) throws IOException {
        block18: {
            block17: {
                if (ArrayType2.getPrimitiveClass() == Byte.class) break block17;
                if (ArrayType2 != ArrayType.CHAR) break block18;
            }
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (ArrayType2 == ArrayType.CHAR) {
                return IospArrayHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Short.class) {
            short[] pa = (short[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readShort(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Integer.class) {
            int[] pa = (int[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readInt(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.FLOAT) {
            float[] pa = (float[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readFloat(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.DOUBLE) {
            double[] pa = (double[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readDouble(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Long.class) {
            long[] pa = (long[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readLong(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRUCTURE) {
            int recsize = index.getElemSize();
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static Object readDataFill(LayoutBB layout, ArrayType ArrayType2, Object fillValue) {
        long size = layout.getTotalNelems();
        if (ArrayType2 == ArrayType.STRUCTURE) {
            size *= (long)layout.getElemSize();
        }
        if (size >= Integer.MAX_VALUE) {
            throw new RuntimeException("Read request too large");
        }
        Object arr = fillValue == null ? IospArrayHelper.makePrimitiveArray((int)size, ArrayType2) : IospArrayHelper.makePrimitiveArray((int)size, ArrayType2, fillValue);
        return IospArrayHelper.readData(layout, ArrayType2, arr);
    }

    public static Object readData(LayoutBB layout, ArrayType ArrayType2, Object arr) {
        block25: {
            block24: {
                if (ArrayType2.getPrimitiveClass() == Byte.class) break block24;
                if (ArrayType2 != ArrayType.CHAR) break block25;
            }
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = bb.get();
                }
            }
            if (ArrayType2 == ArrayType.CHAR) {
                return IospArrayHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Short.class) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ShortBuffer buff = chunk.getShortBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Integer.class) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                IntBuffer buff = chunk.getIntBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                FloatBuffer buff = chunk.getFloatBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                DoubleBuffer buff = chunk.getDoubleBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Long.class) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                LongBuffer buff = chunk.getLongBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem() * recsize);
                int pos = (int)chunk.getDestElem() * recsize;
                for (int i = 0; i < chunk.getNelems() * recsize; ++i) {
                    pa[pos++] = bb.get();
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Object makePrimitiveArray(int size, ArrayType ArrayType2) {
        void var2_10;
        block9: {
            block8: {
                Object var2_2 = null;
                if (ArrayType2.getPrimitiveClass() == Byte.class) break block8;
                if (ArrayType2 == ArrayType.CHAR) break block8;
                if (ArrayType2 == ArrayType.OPAQUE) break block8;
                if (ArrayType2 != ArrayType.STRUCTURE) break block9;
            }
            byte[] byArray = new byte[size];
            return var2_10;
        }
        if (ArrayType2.getPrimitiveClass() == Short.class) {
            short[] sArray = new short[size];
            return var2_10;
        }
        if (ArrayType2.getPrimitiveClass() == Integer.class) {
            int[] nArray = new int[size];
            return var2_10;
        }
        if (ArrayType2.getPrimitiveClass() == Long.class) {
            long[] lArray = new long[size];
            return var2_10;
        }
        if (ArrayType2 == ArrayType.FLOAT) {
            float[] fArray = new float[size];
            return var2_10;
        }
        if (ArrayType2 == ArrayType.DOUBLE) {
            double[] dArray = new double[size];
            return var2_10;
        }
        if (ArrayType2 != ArrayType.STRING) return var2_10;
        String[] stringArray = new String[size];
        return var2_10;
    }

    public static Object makePrimitiveArray(int size, ArrayType ArrayType2, Object fillValue) {
        block28: {
            block27: {
                if (ArrayType2.getPrimitiveClass() == Byte.class) break block27;
                if (ArrayType2 != ArrayType.CHAR) break block28;
            }
            byte[] pa = new byte[size];
            byte val = ((Number)fillValue).byteValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.OPAQUE) {
            return new byte[size];
        }
        if (ArrayType2.getPrimitiveClass() == Short.class) {
            short[] pa = new short[size];
            short val = ((Number)fillValue).shortValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Integer.class) {
            int[] pa = new int[size];
            int val = ((Number)fillValue).intValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2.getPrimitiveClass() == Long.class) {
            long[] pa = new long[size];
            long val = ((Number)fillValue).longValue();
            if (val != 0L) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.FLOAT) {
            float[] pa = new float[size];
            float val = ((Number)fillValue).floatValue();
            if ((double)val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.DOUBLE) {
            double[] pa = new double[size];
            double val = ((Number)fillValue).doubleValue();
            if (val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRING) {
            String[] pa = new String[size];
            for (int i = 0; i < size; ++i) {
                pa[i] = (String)fillValue;
            }
            return pa;
        }
        if (ArrayType2 == ArrayType.STRUCTURE) {
            byte[] pa = new byte[size];
            if (fillValue != null) {
                byte[] val = (byte[])fillValue;
                int count = 0;
                while (count < size && count < val.length) {
                    for (byte aVal : val) {
                        pa[count++] = aVal;
                    }
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static char[] convertByteToCharUTF(byte[] byteArray) {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byteArray)).array();
    }

    public static byte[] convertCharToByteUTF(char[] from) {
        return StandardCharsets.UTF_8.encode(CharBuffer.wrap(from)).array();
    }

    public static char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)ArrayType.unsignedByteToShort(byteArray[i]);
        }
        return cbuff;
    }

    public static byte[] convertCharToByte(char[] from) {
        byte[] to = null;
        if (from != null) {
            int size = from.length;
            to = new byte[size];
            for (int i = 0; i < size; ++i) {
                to[i] = (byte)from[i];
            }
        }
        return to;
    }
}

