/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.Layout;

@Immutable
public class LayoutRegular
implements Layout {
    private final IndexChunker chunker;
    private final long startPos;
    private final int elemSize;

    public LayoutRegular(long startPos, int elemSize, int[] varShape, @Nullable Section wantSection) throws InvalidRangeException {
        Preconditions.checkArgument((startPos >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((elemSize > 0 ? 1 : 0) != 0);
        this.startPos = startPos;
        this.elemSize = elemSize;
        this.chunker = new IndexChunker(varShape, wantSection);
    }

    @Override
    public long getTotalNelems() {
        return this.chunker.getTotalNelems();
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        return this.chunker.hasNext();
    }

    @Override
    public Layout.Chunk next() {
        IndexChunker.Chunk chunk = this.chunker.next();
        chunk.setSrcPos(this.startPos + chunk.getSrcElem() * (long)this.elemSize);
        return chunk;
    }
}

