/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import javax.annotation.Nullable;
import ucar.unidata.io.RandomAccessFile;

public enum NetcdfFileFormat {
    INVALID(0, "Invalid"),
    NETCDF3(1, "NetCDF-3"),
    NETCDF3_64BIT_OFFSET(2, "netcdf-3 64bit-offset"),
    NETCDF4(3, "NetCDF-4"),
    NETCDF4_CLASSIC(4, "netcdf-4 classic"),
    NETCDF3_64BIT_DATA(5, "netcdf-5"),
    NCSTREAM(42, "ncstream");

    private static final int MAGIC_NUMBER_LEN = 8;
    private static final long MAXHEADERPOS = 50000L;
    private static final byte[] H5HEAD;
    private static final byte[] CDF1HEAD;
    private static final byte[] CDF2HEAD;
    private static final byte[] CDF5HEAD;
    private final int version;
    private final String formatName;

    private NetcdfFileFormat(int version, String formatName) {
        this.version = version;
        this.formatName = formatName;
    }

    public int version() {
        return this.version;
    }

    public String formatName() {
        return this.formatName;
    }

    public boolean isNetdf3format() {
        return this == NETCDF3 || this == NETCDF3_64BIT_OFFSET || this == NETCDF3_64BIT_DATA;
    }

    public boolean isNetdf4format() {
        return this == NETCDF4 || this == NETCDF4_CLASSIC;
    }

    public boolean isExtendedModel() {
        return this == NETCDF4 || this == NCSTREAM;
    }

    public boolean isLargeFile() {
        return this == NETCDF3_64BIT_OFFSET;
    }

    public boolean isClassicModel() {
        return this == NETCDF3 || this == NETCDF3_64BIT_OFFSET || this == NETCDF4_CLASSIC || this == NETCDF3_64BIT_DATA;
    }

    @Nullable
    public static NetcdfFileFormat convertVersionToFormat(String netcdfFileWriterVersion) {
        switch (netcdfFileWriterVersion.toLowerCase()) {
            case "netcdf3": {
                return NETCDF3;
            }
            case "netcdf4": {
                return NETCDF4;
            }
            case "netcdf4_classic": {
                return NETCDF4_CLASSIC;
            }
            case "netcdf3c64": {
                return NETCDF3_64BIT_OFFSET;
            }
            case "ncstream": {
                return NCSTREAM;
            }
        }
        return null;
    }

    public static NetcdfFileFormat findNetcdfFormatType(RandomAccessFile raf) throws IOException {
        byte[] magic = new byte[8];
        raf.seek(0L);
        if (raf.readBytes(magic, 0, 8) < 8) {
            return INVALID;
        }
        int hdrlen = CDF1HEAD.length;
        NetcdfFileFormat format = null;
        if (NetcdfFileFormat.memequal(CDF1HEAD, magic, CDF1HEAD.length)) {
            format = NETCDF3;
        } else if (NetcdfFileFormat.memequal(CDF2HEAD, magic, CDF2HEAD.length)) {
            format = NETCDF3_64BIT_OFFSET;
        } else if (NetcdfFileFormat.memequal(CDF5HEAD, magic, CDF5HEAD.length)) {
            format = NETCDF3_64BIT_DATA;
        }
        if (format != null) {
            raf.seek(hdrlen);
            return format;
        }
        long filePos = 0L;
        long size = raf.length();
        while (filePos < size - 8L && filePos < 50000L) {
            raf.seek(filePos);
            if (raf.readBytes(magic, 0, 8) < 8) {
                return INVALID;
            }
            if (NetcdfFileFormat.memequal(H5HEAD, magic, H5HEAD.length)) {
                format = NETCDF4;
                break;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        if (format != null) {
            raf.seek(filePos + (long)H5HEAD.length);
        }
        return format == null ? INVALID : format;
    }

    private static boolean memequal(byte[] b1, byte[] b2, int len) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length < len || b2.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        H5HEAD = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
        CDF1HEAD = new byte[]{67, 68, 70, 1};
        CDF2HEAD = new byte[]{67, 68, 70, 2};
        CDF5HEAD = new byte[]{67, 68, 70, 5};
    }
}

