/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import ucar.array.ArrayType;
import ucar.ma2.DataType;

public class NetcdfFormatUtils {
    public static final byte NC_FILL_BYTE = -127;
    public static final char NC_FILL_CHAR = '\u0000';
    public static final short NC_FILL_SHORT = -32767;
    public static final int NC_FILL_INT = -2147483647;
    public static final float NC_FILL_FLOAT = 9.96921E36f;
    public static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    public static final byte NC_FILL_UBYTE = -1;
    public static final short NC_FILL_USHORT = -1;
    public static final int NC_FILL_UINT = -1;
    public static final long NC_FILL_INT64 = -9223372036854775806L;
    public static final long NC_FILL_UINT64 = -2L;
    public static final String NC_FILL_STRING = "";
    public static final String NETCDF4_COORDINATES = "_Netcdf4Coordinates";
    public static final String NETCDF4_DIMID = "_Netcdf4Dimid";
    public static final String NETCDF4_STRICT = "_nc3_strict";
    public static final String NETCDF4_NON_COORD = "_nc4_non_coord_";

    @Deprecated
    public static Number getFillValueDefault(DataType dtype) {
        return NetcdfFormatUtils.getFillValueDefault(dtype.getArrayType());
    }

    public static Number getFillValueDefault(ArrayType dtype) {
        if (dtype == ArrayType.BYTE || dtype == ArrayType.ENUM1) {
            return (byte)-127;
        }
        if (dtype == ArrayType.UBYTE) {
            return (byte)-1;
        }
        if (dtype == ArrayType.CHAR) {
            return (byte)0;
        }
        if (dtype == ArrayType.SHORT || dtype == ArrayType.ENUM2) {
            return (short)-32767;
        }
        if (dtype == ArrayType.USHORT) {
            return (short)-1;
        }
        if (dtype == ArrayType.INT || dtype == ArrayType.ENUM4) {
            return -2147483647;
        }
        if (dtype == ArrayType.UINT) {
            return -1;
        }
        if (dtype == ArrayType.LONG) {
            return -9223372036854775806L;
        }
        if (dtype == ArrayType.ULONG) {
            return -2L;
        }
        if (dtype == ArrayType.FLOAT) {
            return Float.valueOf(9.96921E36f);
        }
        if (dtype == ArrayType.DOUBLE) {
            return (double)9.96921E36f;
        }
        return null;
    }

    public static boolean isValidNetcdfObjectName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int cp = name.codePointAt(0);
        if (!(cp > 127 || 65 <= cp && cp <= 90 || 97 <= cp && cp <= 122 || 48 <= cp && cp <= 57 || cp == 95)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            cp = name.codePointAt(i);
            if (cp > 127 || cp >= 32 && cp <= 126 && cp != 47) continue;
            return false;
        }
        return cp > 127 || !Character.isWhitespace(cp);
    }

    public static String makeValidNetcdfObjectName(String name) {
        int cp;
        StringBuilder sb = new StringBuilder(name);
        while (!(sb.length() <= 0 || (cp = sb.codePointAt(0)) > 127 || 65 <= cp && cp <= 90 || 97 <= cp && cp <= 122 || 48 <= cp && cp <= 57 || cp == 95)) {
            sb.deleteCharAt(0);
        }
        for (int pos = 1; pos < sb.length(); ++pos) {
            int cp2 = sb.codePointAt(pos);
            if (cp2 > 127 || cp2 >= 32 && cp2 <= 126 && cp2 != 47) continue;
            sb.deleteCharAt(pos);
            --pos;
        }
        while (sb.length() > 0 && (cp = sb.codePointAt(sb.length() - 1)) <= 127 && Character.isWhitespace(cp)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException(String.format("Illegal NetCDF object name: '%s'", name));
        }
        return sb.toString();
    }
}

