/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import ucar.nc2.stream.NcStream;

public class NcStreamCompressedOutputStream
extends DataOutputStream {
    private final OutputStream writer;
    private final DeflaterOutputStream dout;
    private final ByteArrayOutputStream buffer;

    public NcStreamCompressedOutputStream(OutputStream out, int bufferSize, int level) {
        super(out);
        this.writer = out;
        this.buffer = new ByteArrayOutputStream(bufferSize);
        this.dout = level >= 0 ? new DeflaterOutputStream((OutputStream)this.buffer, new Deflater(level), 4096) : new DeflaterOutputStream((OutputStream)this.buffer, new Deflater(), 4096);
        this.out = new BufferedOutputStream(this.dout, 0x100000);
    }

    @Override
    public void flush() throws IOException {
        int compressedSize;
        this.out.flush();
        this.dout.finish();
        this.written = compressedSize = this.buffer.size();
        this.written += NcStream.writeVInt(this.writer, compressedSize);
        this.buffer.writeTo(this.writer);
        this.buffer.reset();
    }
}

