/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamCompressedOutputStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamCompression {
    private static final Logger logger = LoggerFactory.getLogger(NcStreamCompression.class);
    NcStreamProto.Compress type;
    Object compressInfo;

    private NcStreamCompression(NcStreamProto.Compress type, Object info) {
        this.type = type;
        this.compressInfo = info;
    }

    private NcStreamCompression(NcStreamProto.Compress type) {
        this(type, null);
    }

    public static NcStreamCompression none() {
        return new NcStreamCompression(NcStreamProto.Compress.NONE);
    }

    public static NcStreamCompression deflate() {
        return NcStreamCompression.deflate(-1);
    }

    public static NcStreamCompression deflate(int level) {
        return new NcStreamCompression(NcStreamProto.Compress.DEFLATE, level);
    }

    public OutputStream setupStream(OutputStream out, int size) throws IOException {
        switch (this.type) {
            case DEFLATE: {
                int level = Math.min(Math.max((Integer)this.compressInfo, -1), 9);
                int bufferSize = Math.min(size / 2, 0x20000000);
                return new NcStreamCompressedOutputStream(out, bufferSize, level);
            }
            default: {
                logger.info(" Unknown compression type {}. Defaulting to none", (Object)this.type);
            }
            case NONE: 
        }
        NcStream.writeVInt(out, size);
        return out;
    }
}

