/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import javax.annotation.Nullable;
import ucar.unidata.io.RandomAccessFile;

public class IO {
    public static final int default_file_buffersize = 9200;
    public static final int default_socket_buffersize = 64000;
    private static final boolean showCopy = false;

    @Nullable
    public static InputStream getFileResource(String resourcePath) {
        Class<IO> cl = IO.class;
        InputStream is = cl.getResourceAsStream(resourcePath);
        if (is != null) {
            return is;
        }
        try {
            is = new FileInputStream(resourcePath);
        }
        catch (FileNotFoundException | AccessControlException exception) {
            // empty catch block
        }
        return is;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IO.copyBuffered(in, out, 9200);
    }

    public static long copyBuffered(InputStream in, OutputStream out, int buffer_size) throws IOException {
        int bytesRead;
        long totalBytesRead = 0L;
        byte[] buffer = new byte[buffer_size];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        out.flush();
        return totalBytesRead;
    }

    public static long copy2null(InputStream in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        byte[] buffer = new byte[buffersize];
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
        }
        return totalBytesRead;
    }

    public static long copy2null(FileChannel in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = 9200;
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
            buffer.flip();
        }
        return totalBytesRead;
    }

    public static long copyB(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        boolean done = false;
        boolean next = true;
        byte[] buffer = new byte[bufferSize];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            totalBytesRead += (long)n;
        }
        out.flush();
        return totalBytesRead;
    }

    public static void copyMaxBytes(InputStream in, OutputStream out, int maxBytes) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[9200];
        int count = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            int transfer = Math.min(maxBytes - count, bytesRead);
            out.write(buffer, 0, transfer);
            if ((count += transfer) < maxBytes) continue;
            return;
        }
        out.flush();
    }

    public static String readContents(InputStream is) throws IOException {
        return IO.readContents(is, "UTF-8");
    }

    public static String readContents(InputStream is, String charset) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(92000);
        IO.copy(is, bout);
        return bout.toString(charset);
    }

    public static byte[] readContentsToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(92000);
        IO.copy(is, bout);
        return bout.toByteArray();
    }

    public static void writeContents(String contents, OutputStream os) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
        IO.copy(bin, os);
    }

    public static void copyFile(String fileInName, String fileOutName) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileInName);
             FileOutputStream fout = new FileOutputStream(fileOutName);){
            BufferedInputStream in = new BufferedInputStream(fin);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copyFile(File fileIn, File fileOut) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileIn);
             FileOutputStream fout = new FileOutputStream(fileOut);){
            BufferedInputStream in = new BufferedInputStream(fin);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copy2File(byte[] src, String fileOut) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileOut);){
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(fout);
            IO.copy(in, out);
        }
    }

    public static void copyFile(String fileInName, OutputStream out) throws IOException {
        IO.copyFileB(new File(fileInName), out, 9200);
    }

    public static void copyFileB(File fileIn, OutputStream out, int bufferSize) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileIn);){
            BufferedInputStream in = new BufferedInputStream(fin);
            IO.copyB(in, out, bufferSize);
        }
    }

    public static long copyRafB(RandomAccessFile raf, long offset, long length, OutputStream out, byte[] buffer) throws IOException {
        int len;
        long want;
        int bytesRead;
        int bufferSize = buffer.length;
        raf.seek(offset);
        for (want = length; want > 0L && (bytesRead = raf.read(buffer, 0, len = (int)Math.min(want, (long)bufferSize))) > 0; want -= (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
        return length - want;
    }

    public static void copyDirTree(String fromDirName, String toDirName) throws IOException {
        File fromDir = new File(fromDirName);
        File toDir = new File(toDirName);
        if (!fromDir.exists()) {
            return;
        }
        if (!toDir.exists() && !toDir.mkdirs()) {
            throw new IOException("Could not create directory: " + toDir);
        }
        File[] files = fromDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IO.copyDirTree(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
                    continue;
                }
                IO.copyFile(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
            }
        }
    }

    public static byte[] readFileToByteArray(String filename) throws IOException {
        try (FileInputStream fin = new FileInputStream(filename);){
            BufferedInputStream in = new BufferedInputStream(fin);
            byte[] byArray = IO.readContentsToByteArray(in);
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static String readFile(String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeToFile(String contents, File file) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(file);
             OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fout, StandardCharsets.UTF_8);){
            fw.write(contents);
        }
    }

    public static void writeToFile(byte[] contents, File file) throws IOException {
        try (FileOutputStream fw = new FileOutputStream(file);){
            fw.write(contents);
            fw.flush();
        }
    }

    public static void writeToFile(String contents, String fileOutName) throws IOException {
        IO.writeToFile(contents, new File(fileOutName));
    }

    /*
     * Loose catch block
     */
    public static long writeToFile(InputStream in, String fileOutName) throws IOException {
        try {
            try (FileOutputStream fout = new FileOutputStream(fileOutName);){
                BufferedOutputStream out = new BufferedOutputStream(fout);
                long l = IO.copy(in, out);
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    public static long appendToFile(InputStream in, String fileOutName) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileOutName, true);){
            BufferedOutputStream out = new BufferedOutputStream(fout);
            long l = IO.copy(in, out);
            return l;
        }
    }
}

