/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.Arrays;
import ucar.array.Index;
import ucar.array.InvalidRangeException;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.write.CDLWriter;
import ucar.nc2.write.NcmlWriter;

@Immutable
public class NcdumpArray {
    private final NetcdfFile ncfile;
    private final WantValues wantValues;
    private final boolean ncml;
    private final boolean strict;
    private final String varNames;
    private final String locationName;
    private final CancelTask cancelTask;
    private static final String usage = "usage: Ncdump <filename> [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ncdump(String command, Writer out, CancelTask cancel) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage);
            return;
        }
        String filename = stoke.nextToken();
        try (NetcdfFile nc = NetcdfDatasets.openFile(filename, cancel);){
            int pos = command.indexOf(filename);
            command = command.substring(pos + filename.length());
            NcdumpArray.ncdump(nc, command, out, cancel);
        }
        catch (FileNotFoundException e) {
            out.write("file not found= ");
            out.write(filename);
        }
        finally {
            out.close();
        }
    }

    public static void ncdump(NetcdfFile nc, String command, Writer out, CancelTask cancel) throws IOException {
        WantValues showValues = WantValues.none;
        Builder builder = NcdumpArray.builder(nc).setCancelTask(cancel);
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    builder.setNcml(true);
                }
                if (toke.equalsIgnoreCase("-cdl") || toke.equalsIgnoreCase("-strict")) {
                    builder.setStrict(true);
                }
                if (toke.equalsIgnoreCase("-v") && stoke.hasMoreTokens()) {
                    builder.setVarNames(stoke.nextToken());
                }
                if (!toke.equalsIgnoreCase("-datasetname") || !stoke.hasMoreTokens()) continue;
                builder.setLocationName(stoke.nextToken());
            }
        }
        builder.setWantValues(showValues);
        out.write(builder.build().print());
        out.flush();
    }

    public static Builder builder(NetcdfFile ncfile) {
        return new Builder(ncfile);
    }

    private NcdumpArray(Builder builder) {
        this.ncfile = builder.ncfile;
        this.wantValues = builder.wantValues;
        this.ncml = builder.ncml;
        this.strict = builder.strict;
        this.varNames = builder.varNames;
        this.locationName = builder.locationName;
        this.cancelTask = builder.cancelTask;
    }

    public String print() {
        Formatter out;
        block16: {
            boolean headerOnly = this.wantValues == WantValues.none && this.varNames == null;
            out = new Formatter();
            try {
                if (this.ncml) {
                    return NcdumpArray.writeNcml(this.ncfile, this.wantValues, this.locationName);
                }
                if (headerOnly) {
                    CDLWriter.writeCDL(this.ncfile, out, this.strict, this.locationName);
                    break block16;
                }
                Indent indent = new Indent(2);
                CDLWriter cdlWriter = new CDLWriter(this.ncfile, out, this.strict);
                cdlWriter.toStringStart(indent, this.strict, this.locationName);
                indent.incr();
                out.format("%n%sdata:%n", indent);
                indent.incr();
                if (this.wantValues == WantValues.all) {
                    for (Variable v : this.ncfile.getVariables()) {
                        NcdumpArray.printArray(out, v.readArray(), v.getFullName(), indent, this.cancelTask);
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                } else if (this.wantValues == WantValues.coordsOnly) {
                    for (Variable v : this.ncfile.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            NcdumpArray.printArray(out, v.readArray(), v.getFullName(), indent, this.cancelTask);
                        }
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                }
                if (this.wantValues != WantValues.all && this.varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(this.varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array<?> data = this.ncfile.readSectionArray(varSubset);
                            NcdumpArray.printArray(out, data, varSubset, indent, this.cancelTask);
                        } else {
                            Variable v = this.ncfile.findVariable(varSubset);
                            if (v == null) {
                                out.format(" cant find variable: %s%n   %s", varSubset, usage);
                                continue;
                            }
                            if (this.wantValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                NcdumpArray.printArray(out, v.readArray(), v.getFullName(), indent, this.cancelTask);
                            }
                        }
                        if (this.cancelTask == null || !this.cancelTask.isCancel()) continue;
                        return out.toString();
                    }
                }
                indent.decr();
                indent.decr();
                cdlWriter.toStringEnd();
            }
            catch (Exception e) {
                out.format("%n%s%n", e.getMessage());
            }
        }
        return out.toString();
    }

    public static String printVariableData(Variable v, CancelTask cancel) throws IOException {
        Array<?> data = v.readArray();
        Formatter out = new Formatter();
        NcdumpArray.printArray(out, data, v.getFullName(), new Indent(2), cancel);
        return out.toString();
    }

    public static String printArrayPlain(Array<?> array) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Object val : array) {
            pw.print(val);
            pw.print(' ');
        }
        return sw.toString();
    }

    public static String printArray(Array<?> ma) {
        return NcdumpArray.printArray(ma, "", null);
    }

    public static String printArray(Array<?> array, String name, CancelTask cancel) {
        Formatter out = new Formatter();
        NcdumpArray.printArray(out, array, name, null, new Indent(2), cancel);
        return out.toString();
    }

    private static void printArray(Formatter out, Array<?> array, String name, Indent indent, CancelTask cancel) {
        NcdumpArray.printArray(out, array, name, null, indent, cancel);
        out.flush();
    }

    private static void printArray(Formatter out, Array<?> array, String name, String units, Indent ilev, CancelTask cancel) {
        if (cancel != null && cancel.isCancel()) {
            return;
        }
        if (name != null) {
            out.format("%s%s = ", ilev, name);
        }
        ilev.incr();
        if (array == null) {
            out.format("null array for %s", name);
            ilev.decr();
            return;
        }
        if (array.getArrayType() == ArrayType.CHAR) {
            NcdumpArray.printCharArray(out, array, ilev, cancel);
        } else if (array.getArrayType() == ArrayType.STRING) {
            NcdumpArray.printStringArray(out, array, ilev, cancel);
        } else if (array instanceof StructureDataArray) {
            NcdumpArray.printStructureDataArray(out, (StructureDataArray)array, ilev, cancel);
        } else if (array.getArrayType() == ArrayType.OPAQUE) {
            ArrayVlen vlen = (ArrayVlen)array;
            int count = 0;
            for (Array<Byte> inner : vlen) {
                out.format("%s%n", count == 0 ? "," : ";");
                NcdumpArray.printByteBuffer(out, Arrays.getByteBuffer(inner), ilev);
                if (cancel != null && cancel.isCancel()) {
                    return;
                }
                ++count;
            }
        } else if (array instanceof ArrayVlen) {
            NcdumpArray.printVariableArray(out, (ArrayVlen)array, ilev, cancel);
        } else {
            NcdumpArray.printArray(out, array, ilev, cancel);
        }
        if (units != null) {
            out.format(" %s", units);
        }
        out.format("%n", new Object[0]);
        ilev.decr();
        out.flush();
    }

    private static void printArray(Formatter out, Array<?> ma, Indent indent, CancelTask cancel) {
        if (cancel != null && cancel.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 0) {
            Object value = ma.getScalar();
            if (ma.getArrayType().isUnsigned()) {
                assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                value = ArrayType.widenNumberIfNegative((Number)value);
            }
            out.format("%s", value);
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        Index ima = ma.getIndex();
        if (rank == 1 && ma.getArrayType() != ArrayType.STRUCTURE) {
            for (int ii = 0; ii < last; ++ii) {
                Object value = ma.get(ima.setElem(ii));
                if (ma.getArrayType().isUnsigned()) {
                    assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                    value = ArrayType.widenNumberIfNegative((Number)value);
                }
                if (ii > 0) {
                    out.format(", ", new Object[0]);
                }
                out.format("%s", value);
                if (cancel == null || !cancel.isCancel()) continue;
                return;
            }
            out.format("}", new Object[0]);
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array<?> slice = null;
            try {
                slice = Arrays.slice(ma, 0, ii);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            NcdumpArray.printArray(out, slice, indent, cancel);
            if (cancel == null || !cancel.isCancel()) continue;
            return;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printCharArray(Formatter out, Array<Byte> ma, Indent indent, CancelTask cancel) {
        if (cancel != null && cancel.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.format("  \"%s\"", Arrays.makeStringFromChar(ma));
            return;
        }
        if (rank == 2) {
            boolean first = true;
            Array<String> strings = Arrays.makeStringsFromChar(ma);
            for (String s : strings) {
                if (!first) {
                    out.format(", ", new Object[0]);
                }
                out.format("  \"%s\"", s);
                first = false;
                if (cancel == null || !cancel.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array<Byte> slice = null;
            try {
                slice = Arrays.slice(ma, 0, ii);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            NcdumpArray.printCharArray(out, slice, indent, cancel);
            if (cancel == null || !cancel.isCancel()) continue;
            return;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printByteBuffer(Formatter out, ByteBuffer bb, Indent indent) {
        out.format("%s0x", indent);
        int last = bb.limit() - 1;
        if (last < 0) {
            out.format("00", new Object[0]);
        } else {
            for (int i = bb.position(); i <= last; ++i) {
                out.format("%02x", bb.get(i));
            }
        }
    }

    private static void printStringArray(Formatter out, Array<String> ma, Indent indent, CancelTask cancel) {
        if (cancel != null && cancel.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 0) {
            out.format("  \"%s\"", ma.get(0));
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.length()) {
                if (!first) {
                    out.format(", ", new Object[0]);
                }
                out.format("  \"%s\"", ma.get(i++));
                first = false;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.format("%n%s{", indent);
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array<String> slice = null;
            try {
                slice = Arrays.slice(ma, 0, ii);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            if (ii > 0) {
                out.format(",", new Object[0]);
            }
            NcdumpArray.printStringArray(out, slice, indent, cancel);
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    private static void printStructureDataArray(Formatter out, StructureDataArray array, Indent indent, CancelTask cancel) {
        int count = 0;
        for (StructureData sdata : array) {
            out.format("%n%s{", indent);
            NcdumpArray.printStructureData(out, sdata, indent, cancel);
            out.format("%s} %s(%d)", indent, sdata.getName(), count);
            if (cancel != null && cancel.isCancel()) {
                return;
            }
            ++count;
        }
    }

    private static void printVariableArray(Formatter out, ArrayVlen<?> vlen, Indent indent, CancelTask cancel) {
        out.format("%n%s{", indent);
        indent.incr();
        int count = 0;
        for (Array<?> inner : vlen) {
            out.format("%s%n", count == 0 ? "," : ";");
            NcdumpArray.printArray(out, inner, indent, cancel);
            if (cancel != null && cancel.isCancel()) {
                return;
            }
            ++count;
        }
        indent.decr();
        out.format("%n%s}", indent);
    }

    public static String printStructureData(StructureData sdata) {
        Formatter out = new Formatter();
        for (StructureMembers.Member m : sdata.getStructureMembers()) {
            Array<Byte> memData = sdata.getMemberData(m);
            if (memData.getArrayType() == ArrayType.CHAR) {
                out.format("%s", Arrays.makeStringFromChar(memData));
            } else {
                NcdumpArray.printArray(out, memData, null, null, new Indent(2), null);
            }
            out.format(",", new Object[0]);
        }
        return out.toString();
    }

    private static void printStructureData(Formatter out, StructureData sdata, Indent indent, CancelTask cancel) {
        indent.incr();
        for (StructureMembers.Member m : sdata.getStructureMembers()) {
            Array<?> sdataArray = sdata.getMemberData(m);
            NcdumpArray.printArray(out, sdataArray, m.getName(), m.getUnitsString(), indent, cancel);
            if (cancel == null || !cancel.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    private static String writeNcml(NetcdfFile ncfile, WantValues showValues, @Nullable String url) {
        Predicate<? super Variable> writeVarsPred;
        Preconditions.checkNotNull((Object)ncfile);
        Preconditions.checkNotNull((Object)((Object)showValues));
        switch (showValues) {
            case none: {
                writeVarsPred = NcmlWriter.writeNoVariablesPredicate;
                break;
            }
            case coordsOnly: {
                writeVarsPred = NcmlWriter.writeCoordinateVariablesPredicate;
                break;
            }
            case all: {
                writeVarsPred = NcmlWriter.writeAllVariablesPredicate;
                break;
            }
            default: {
                String message = String.format("CAN'T HAPPEN: showValues (%s) != null and checked all possible enum values.", new Object[]{showValues});
                throw new AssertionError((Object)message);
            }
        }
        NcmlWriter ncmlWriter = new NcmlWriter(null, null, writeVarsPred);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(ncfile, url);
        return ncmlWriter.writeToString(netcdfElement);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        String filename = args[0];
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
             NetcdfFile nc = NetcdfDatasets.openFile(filename, null);){
            StringBuilder command = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                command.append(args[i]);
                command.append(" ");
            }
            NcdumpArray.ncdump(nc, command.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static class Builder {
        private final NetcdfFile ncfile;
        private WantValues wantValues = WantValues.none;
        private boolean ncml;
        private boolean strict;
        private String varNames;
        @Nullable
        private String locationName;
        private CancelTask cancelTask;

        private Builder(NetcdfFile ncfile) {
            this.ncfile = ncfile;
        }

        public Builder setShowAllValues() {
            this.wantValues = WantValues.all;
            return this;
        }

        public Builder setShowCoordValues() {
            this.wantValues = WantValues.coordsOnly;
            return this;
        }

        public Builder setLocationName(String locationName) {
            if (locationName != null && !locationName.isEmpty()) {
                this.locationName = locationName;
            }
            return this;
        }

        public Builder setWantValues(WantValues wantValues) {
            this.wantValues = wantValues;
            return this;
        }

        public Builder setNcml(boolean ncml) {
            this.ncml = ncml;
            return this;
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder setVarNames(String varNames) {
            this.varNames = varNames;
            return this;
        }

        public Builder setCancelTask(CancelTask cancelTask) {
            this.cancelTask = cancelTask;
            return this;
        }

        public NcdumpArray build() {
            return new NcdumpArray(this);
        }
    }

    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

