/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.write.ChunkingIndex;
import ucar.nc2.write.NetcdfFormatWriter;

public class NetcdfCopier
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(NetcdfCopier.class);
    private static final long maxSize = 50000000L;
    private static boolean debug;
    private static boolean debugWrite;
    private final NetcdfFile fileIn;
    private final NetcdfFormatWriter.Builder<?> writerb;
    private final boolean extended;

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter/debug");
        debugWrite = debugFlags.isSet("ncfileWriter/debugWrite");
    }

    public static NetcdfCopier create(NetcdfFile fileIn, NetcdfFormatWriter.Builder<?> ncwriter) {
        Preconditions.checkNotNull((Object)fileIn);
        Preconditions.checkNotNull(ncwriter);
        return new NetcdfCopier(fileIn, ncwriter);
    }

    private NetcdfCopier(NetcdfFile fileIn, NetcdfFormatWriter.Builder<?> writerb) {
        this.fileIn = fileIn;
        this.writerb = writerb;
        this.extended = this.getOutputFormat().isExtendedModel();
        if (!fileIn.getRootGroup().getGroups().isEmpty() && !this.extended) {
            throw new IllegalStateException("Input file has nested groups: cannot write to format= " + (Object)((Object)this.getOutputFormat()));
        }
    }

    private NetcdfFileFormat getOutputFormat() {
        return this.writerb.format;
    }

    public void write(@Nullable CancelTask cancel) throws IOException {
        if (cancel == null) {
            cancel = CancelTask.create();
        }
        Group.Builder root = this.fileIn.getRootGroup().toBuilder();
        this.convertGroup(root);
        this.writerb.setRootGroup(root);
        if (cancel.isCancel()) {
            return;
        }
        try (NetcdfFormatWriter ncwriter = this.writerb.build();){
            if (cancel.isCancel()) {
                return;
            }
            Count counter = new Count();
            this.copyVariableData(ncwriter, this.fileIn.getRootGroup(), ncwriter.getRootGroup(), counter, cancel);
            if (cancel.isCancel()) {
                return;
            }
            System.out.format("FileCopier done: total bytes written = %d, number of variables = %d%n", counter.bytes, counter.countVars);
        }
    }

    private Attribute convertAttribute(Attribute org) {
        if (this.extended) {
            return org;
        }
        if (org.isString() && org.getLength() > 1) {
            Formatter f = new Formatter();
            for (int count = 0; count < org.getLength(); ++count) {
                if (count > 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%s", org.getStringValue(count));
            }
            return Attribute.builder().setName(org.getShortName()).setStringValue(f.toString()).build();
        }
        if (!org.getDataType().isUnsigned()) {
            return org;
        }
        Array orgValues = org.getValues();
        Array nc3Values = Array.makeFromJavaArray(orgValues.getStorage(), false);
        return Attribute.builder().setName(org.getShortName()).setValues(nc3Values).build();
    }

    private void convertAttributes(AttributeContainerMutable atts) {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        for (Attribute att : atts) {
            newAtts.add(this.convertAttribute(att));
        }
        atts.clear().addAll(newAtts);
    }

    private void convertGroup(Group.Builder group) throws IOException {
        this.convertAttributes(group.getAttributeContainer());
        for (Variable.Builder<?> var : group.vbuilders) {
            this.convertVariable(group, var);
        }
        for (Group.Builder nested : group.gbuilders) {
            if (!this.extended) {
                throw new RuntimeException("Cant write nested groups to classic netcdf");
            }
            this.convertGroup(nested);
        }
    }

    private void convertVariable(Group.Builder parent, Variable.Builder<?> vb) throws IOException {
        vb.setSPobject(null);
        vb.setProxyReader(null);
        vb.resetCache();
        vb.resetAutoGen();
        this.convertAttributes(vb.getAttributeContainer());
        if (vb.dataType == ArrayType.STRUCTURE) {
            Structure.Builder sb = (Structure.Builder)vb;
            for (Variable.Builder<?> nested : sb.vbuilders) {
                this.convertVariable(parent, nested);
            }
        } else if (!this.extended && vb.dataType == ArrayType.STRING) {
            Array data = this.readDataFromOriginal(vb);
            IndexIterator ii = data.getIndexIterator();
            int max_len = 0;
            while (ii.hasNext()) {
                String s = (String)ii.getObjectNext();
                max_len = Math.max(max_len, s.length());
            }
            String strlenDimName = vb.shortName + "_strlen";
            Dimension strlenDim = Dimension.builder(strlenDimName, max_len).setIsShared(false).build();
            parent.addDimension(strlenDim);
            vb.addDimension(strlenDim);
            vb.setArrayType(ArrayType.CHAR);
        }
        if (!this.extended) {
            int count = 0;
            for (Dimension dim : vb.getDimensions()) {
                if (!dim.isShared()) {
                    String dimName = vb.shortName + "_Dim" + count;
                    Dimension sharedDim = Dimension.builder(dimName, dim.getLength()).setIsShared(false).build();
                    parent.addDimension(sharedDim);
                    vb.replaceDimension(count, sharedDim);
                }
                ++count;
            }
        }
    }

    private Array readDataFromOriginal(Variable.Builder<?> vb) throws IOException {
        Variable v = this.fileIn.findVariable(vb.getFullName());
        if (v == null) {
            throw new RuntimeException("Cant find variable" + vb.getFullName());
        }
        return v.read();
    }

    @Override
    public void close() throws IOException {
    }

    private void copyVariableData(NetcdfFormatWriter ncwriter, Group groupIn, Group groupOut, Count counter, CancelTask cancel) throws IOException {
        for (Variable oldVar : groupIn.getVariables()) {
            if (cancel.isCancel()) break;
            Variable newVar = groupOut.findVariableLocal(oldVar.getShortName());
            if (debug) {
                System.out.format("write var= %s size = %d type = %s%n", new Object[]{oldVar.getFullName(), oldVar.getSize(), oldVar.getDataType()});
            }
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            counter.bytes += size;
            if (size <= 50000000L) {
                this.copyAll(ncwriter, oldVar, newVar);
            } else {
                this.copySome(ncwriter, oldVar, newVar, 50000000L, cancel);
            }
            ++counter.countVars;
        }
        for (Group nestedIn : groupIn.getGroups()) {
            if (cancel.isCancel()) break;
            Group nestedOut = groupOut.findGroupLocal(nestedIn.getShortName());
            this.copyVariableData(ncwriter, nestedIn, nestedOut, counter, cancel);
        }
    }

    private void copyAll(NetcdfFormatWriter ncwriter, Variable oldVar, Variable newVar) throws IOException {
        Array data = oldVar.read();
        try {
            if (!this.extended && oldVar.getArrayType() == ArrayType.STRING) {
                data = this.convertDataToChar(newVar, data);
            }
            if (data.getSize() > 0L) {
                ncwriter.write(newVar, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private void copySome(NetcdfFormatWriter ncwriter, Variable oldVar, Variable newVar, long maxChunkSize, CancelTask cancel) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        long byteWriteTotal = 0L;
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                Array data = oldVar.read(chunkOrigin, chunkShape);
                if (!this.getOutputFormat().isNetdf4format() && oldVar.getArrayType() == ArrayType.STRING) {
                    data = this.convertDataToChar(newVar, data);
                }
                if (data.getSize() > 0L) {
                    ncwriter.write(newVar, chunkOrigin, data);
                    if (debugWrite) {
                        System.out.println(" write " + data.getSize() + " bytes at " + new Section(chunkOrigin, chunkShape));
                    }
                    byteWriteTotal += data.getSize();
                }
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
                if (!cancel.isCancel()) continue;
                return;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Array convertDataToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s);
        }
        return newData;
    }

    private static class Count {
        long bytes;
        int countVars;

        private Count() {
        }
    }
}

