/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.ArraysConvert;
import ucar.array.Index;
import ucar.array.InvalidRangeException;
import ucar.array.StructureData;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.IospFileWriter;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.internal.iosp.netcdf3.N3iosp;
import ucar.nc2.internal.iosp.netcdf3.N3iospWriter;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.nc2.write.UnlimitedDimension;
import ucar.unidata.io.RandomAccessFile;

public class NetcdfFormatWriter
implements Closeable {
    final String location;
    final boolean fill;
    final int extraHeaderBytes;
    final long preallocateSize;
    final Nc4Chunking chunker;
    final boolean isExisting;
    final NetcdfFileFormat format;
    final boolean useJna;
    final NetcdfFile ncout;
    final IospFileWriter spiw;
    private boolean isClosed = false;

    public static Builder<?> createNewNetcdf3(String location) {
        return ((Builder)NetcdfFormatWriter.builder().setFormat(NetcdfFileFormat.NETCDF3)).setLocation(location);
    }

    public static Builder<?> createNewNetcdf4(String location) {
        return ((Builder)((Builder)NetcdfFormatWriter.builder().setFormat(NetcdfFileFormat.NETCDF4)).setLocation(location)).setChunker(new Nc4ChunkingDefault());
    }

    public static Builder<?> createNewNetcdf4(NetcdfFileFormat format, String location, @Nullable Nc4Chunking chunker) {
        return ((Builder)((Builder)NetcdfFormatWriter.builder().setFormat(format)).setLocation(location)).setChunker(chunker);
    }

    public static Builder<?> openExisting(String location) throws IOException {
        try (NetcdfFile ncfile = NetcdfFiles.open(location);){
            IOServiceProvider iosp = (IOServiceProvider)ncfile.sendIospMessage("IOSP");
            Preconditions.checkArgument((iosp instanceof N3iosp || iosp instanceof H5iosp || iosp.getClass().getName().endsWith("Nc4reader") ? 1 : 0) != 0, (Object)"Can only modify Netcdf-3 or Netcdf-4 files");
            Group.Builder root = ncfile.getRootGroup().toBuilder();
            NetcdfFileFormat format = (NetcdfFileFormat)((Object)iosp.sendIospMessage("NetcdfFileFormat"));
            if (format != null && !format.isNetdf3format() && !format.isNetdf4format()) {
                throw new IllegalArgumentException(String.format("%s is not a netcdf-3 or netcdf-4 file (%s)", new Object[]{location, format}));
            }
            Object t = ((Builder)((Builder)((Builder)NetcdfFormatWriter.builder().setRootGroup(root)).setLocation(location)).setIosp(iosp).setFormat(format)).setIsExisting();
            return t;
        }
    }

    public Group getRootGroup() {
        return this.ncout.getRootGroup();
    }

    public NetcdfFileFormat getFormat() {
        return this.format;
    }

    @Nullable
    public Variable findVariable(String fullNameEscaped) {
        return this.ncout.findVariable(fullNameEscaped);
    }

    @Nullable
    public Dimension findDimension(String dimName) {
        return this.ncout.findDimension(dimName);
    }

    @Nullable
    public Attribute findGlobalAttribute(String attName) {
        return this.getRootGroup().findAttribute(attName);
    }

    public long calcSize() {
        return this.calcSize(this.getRootGroup());
    }

    private long calcSize(Group group) {
        long totalSizeOfVars = 0L;
        for (Variable var : group.getVariables()) {
            totalSizeOfVars += Dimensions.getSize(var.getDimensions()) * (long)var.getElementSize();
        }
        for (Group nested : group.getGroups()) {
            totalSizeOfVars += this.calcSize(nested);
        }
        return totalSizeOfVars;
    }

    public void write(Variable v, Index origin, ucar.array.Array<?> values) throws IOException, InvalidRangeException {
        Preconditions.checkArgument((v.getArrayType() == values.getArrayType() ? 1 : 0) != 0);
        Preconditions.checkArgument((v.getRank() == values.getRank() ? 1 : 0) != 0);
        Array oldArray = ArraysConvert.convertFromArray(values);
        try {
            this.write(v, origin.getCurrentIndex(), oldArray);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
    }

    public void writeStringData(Variable v, Index origin, String data) throws IOException, InvalidRangeException {
        Preconditions.checkArgument((v.getArrayType() == ArrayType.CHAR ? 1 : 0) != 0);
        Preconditions.checkArgument((v.getRank() > 0 ? 1 : 0) != 0);
        int rank = v.getRank();
        int[] offset = origin.getCurrentIndex();
        Array cvalues = ArrayChar.makeFromString(data, v.getShape(rank - 1));
        if (rank > 1) {
            cvalues = cvalues.extend(rank);
        }
        try {
            this.write(v, offset, cvalues);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
        if (rank > 1) {
            origin.incr(rank - 2);
        }
    }

    public int appendStructureData(Structure s, StructureData sdata) throws IOException, InvalidRangeException {
        StructureMembers membersMa2 = s.makeStructureMembers();
        ucar.ma2.StructureData oldStructure = ArraysConvert.convertStructureData(membersMa2, sdata);
        try {
            return this.appendStructureData(s, oldStructure);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
    }

    @Deprecated
    public void write(Variable v, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        this.write(v, new int[values.getRank()], values);
    }

    @Deprecated
    public void write(String varName, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        Variable v = this.findVariable(varName);
        Preconditions.checkNotNull((Object)v);
        this.write(v, values);
    }

    @Deprecated
    public void write(Variable v, int[] origin, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        this.spiw.writeData(v, new Section(origin, values.getShape()), values);
    }

    @Deprecated
    public void write(String varName, int[] origin, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        Variable v = this.findVariable(varName);
        Preconditions.checkNotNull((Object)v);
        this.write(v, origin, values);
    }

    @Deprecated
    public void writeStringDataToChar(Variable v, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        this.writeStringDataToChar(v, new int[values.getRank()], values);
    }

    @Deprecated
    public void writeStringDataToChar(Variable v, int[] origin, Array values) throws IOException, ucar.ma2.InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("values must be an ArrayObject of String ");
        }
        if (v.getArrayType() != ArrayType.CHAR) {
            throw new IllegalArgumentException("variable " + v.getFullName() + " is not type CHAR");
        }
        int rank = v.getRank();
        int strlen = v.getShape(rank - 1);
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(v, corigin, (Array)cvalues);
    }

    @Deprecated
    public int appendStructureData(Structure s, ucar.ma2.StructureData sdata) throws IOException, ucar.ma2.InvalidRangeException {
        return this.spiw.appendStructureData(s, sdata);
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.spiw.updateAttribute(v2, att);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.spiw.close();
            this.isClosed = true;
        }
    }

    public void abort() throws IOException {
        if (!this.isClosed) {
            this.spiw.close();
            this.isClosed = true;
        }
    }

    NetcdfFormatWriter(Builder<?> builder) throws IOException {
        this.location = builder.location;
        this.fill = builder.fill;
        this.extraHeaderBytes = builder.extraHeaderBytes;
        this.preallocateSize = builder.preallocateSize;
        this.chunker = builder.chunker;
        this.isExisting = builder.isExisting;
        if (this.isExisting) {
            try (RandomAccessFile existingRaf = new RandomAccessFile(this.location, "r");){
                this.format = NetcdfFileFormat.findNetcdfFormatType(existingRaf);
            }
            this.useJna = builder.useJna || this.format.isNetdf4format();
            IospFileWriter spi = this.useJna ? this.openJna("ucar.nc2.jni.netcdf.Nc4updater") : new N3iospWriter(builder.iosp);
            try {
                spi.openForWriting(this.location, builder.rootGroup, null);
                spi.setFill(this.fill);
            }
            catch (Throwable t) {
                spi.close();
                throw t;
            }
            this.ncout = spi.getOutputFile();
            this.spiw = spi;
        } else {
            this.format = builder.format;
            this.useJna = builder.useJna || this.format.isNetdf4format();
            IospFileWriter spi = this.useJna ? this.openJna("ucar.nc2.jni.netcdf.Nc4writer") : new N3iospWriter();
            try {
                this.ncout = spi.create(this.location, builder.rootGroup, this.extraHeaderBytes, this.preallocateSize, this.format.isLargeFile());
                spi.setFill(this.fill);
            }
            catch (Throwable t) {
                spi.close();
                throw t;
            }
            this.spiw = spi;
        }
    }

    private IospFileWriter openJna(String className) {
        IospFileWriter spi;
        try {
            Class<?> iospClass = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> ctor = iospClass.getConstructor(((Object)((Object)this.format)).getClass());
            spi = (IospFileWriter)ctor.newInstance(new Object[]{this.format});
            Method method = iospClass.getMethod("setChunker", Nc4Chunking.class);
            method.invoke((Object)spi, this.chunker);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalArgumentException(className + " cannot use JNI/C library err= " + e.getMessage());
        }
        return spi;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public WriteConfig config() {
        return new WriteConfig();
    }

    public class WriteConfig {
        Variable v;
        String varName;
        Index origin;
        Object primArray;
        ucar.array.Array<?> values;
        int[] shape;
        String sval;

        public WriteConfig forVariable(Variable v) {
            this.v = v;
            return this;
        }

        public WriteConfig forVariable(String varName) {
            this.varName = varName;
            return this;
        }

        public WriteConfig withOrigin(Index origin) {
            this.origin = origin;
            return this;
        }

        public WriteConfig withOrigin(int ... origin) {
            this.origin = Index.of(origin);
            return this;
        }

        public WriteConfig withArray(ucar.array.Array<?> values) {
            this.values = values;
            return this;
        }

        public WriteConfig withPrimitiveArray(Object primArray) {
            this.primArray = primArray;
            return this;
        }

        public WriteConfig withShape(int ... shape) {
            this.shape = shape;
            return this;
        }

        public WriteConfig withString(String sval) {
            this.sval = sval;
            return this;
        }

        public void write() throws IOException, InvalidRangeException, IllegalArgumentException {
            if (this.v == null && this.varName == null) {
                throw new IllegalArgumentException("Must set Variable");
            }
            if (this.v == null) {
                this.v = NetcdfFormatWriter.this.findVariable(this.varName);
                if (this.v == null) {
                    throw new IllegalArgumentException("Unknown Variable " + this.varName);
                }
            }
            if (this.origin == null) {
                this.origin = Index.ofRank(this.v.getRank());
            }
            if (this.sval != null) {
                NetcdfFormatWriter.this.writeStringData(this.v, this.origin, this.sval);
                return;
            }
            if (this.values == null) {
                if (this.primArray == null) {
                    throw new IllegalArgumentException("Must set Array or primitive array");
                }
                if (this.shape == null) {
                    this.shape = this.v.getShape();
                }
                this.values = Arrays.factory(this.v.getArrayType(), this.shape, this.primArray);
            }
            NetcdfFormatWriter.this.write(this.v, this.origin, this.values);
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        String location;
        boolean fill = true;
        int extraHeaderBytes;
        long preallocateSize;
        Nc4Chunking chunker;
        boolean useJna;
        boolean isExisting;
        NetcdfFileFormat format = NetcdfFileFormat.NETCDF3;
        IOServiceProvider iosp;
        Group.Builder rootGroup = Group.builder().setName("");

        protected abstract T self();

        public Builder<?> setIosp(IOServiceProvider iosp) {
            this.iosp = iosp;
            return this;
        }

        public T setLocation(String location) {
            this.location = location;
            return this.self();
        }

        public T setIsExisting() {
            this.isExisting = true;
            return this.self();
        }

        public T setFill(boolean fill) {
            this.fill = fill;
            return this.self();
        }

        public T setFormat(NetcdfFileFormat format) {
            this.format = format;
            return this.self();
        }

        public T setExtraHeader(int extraHeaderBytes) {
            this.extraHeaderBytes = extraHeaderBytes;
            return this.self();
        }

        public T setPreallocateSize(long preallocateSize) {
            this.preallocateSize = preallocateSize;
            return this.self();
        }

        public T setChunker(Nc4Chunking chunker) {
            this.chunker = chunker;
            return this.self();
        }

        public T setUseJna(boolean useJna) {
            this.useJna = useJna;
            return this.self();
        }

        public T addAttribute(Attribute att) {
            this.rootGroup.addAttribute(att);
            return this.self();
        }

        public Dimension addDimension(String dimName, int length) {
            return this.addDimension(new Dimension(dimName, length));
        }

        public Dimension addDimension(Dimension dim) {
            Dimension useDim = dim;
            if (dim.isUnlimited() && !(dim instanceof UnlimitedDimension)) {
                useDim = new UnlimitedDimension(dim.getShortName(), dim.getLength());
            }
            this.rootGroup.addDimension(useDim);
            return useDim;
        }

        public Dimension addUnlimitedDimension(String dimName) {
            return this.addDimension(new UnlimitedDimension(dimName, 0));
        }

        public Group.Builder getRootGroup() {
            return this.rootGroup;
        }

        public T setRootGroup(Group.Builder rootGroup) {
            this.rootGroup = rootGroup;
            return this.self();
        }

        @Deprecated
        public Variable.Builder<?> addVariable(String shortName, DataType dataType, String dimString) {
            return this.addVariable(shortName, dataType.getArrayType(), dimString);
        }

        public Variable.Builder<?> addVariable(String shortName, ArrayType dataType, String dimString) {
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setArrayType(dataType)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimString);
            this.rootGroup.addVariable((Variable.Builder<?>)vb);
            return vb;
        }

        @Deprecated
        public Variable.Builder<?> addVariable(String shortName, DataType dataType, List<Dimension> dims) {
            return this.addVariable(shortName, dataType.getArrayType(), dims);
        }

        public Variable.Builder<?> addVariable(String shortName, ArrayType dataType, List<Dimension> dims) {
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setArrayType(dataType)).setParentGroupBuilder(this.rootGroup)).setDimensions(dims);
            this.rootGroup.addVariable((Variable.Builder<?>)vb);
            return vb;
        }

        public Structure.Builder<?> addStructure(String shortName, String dimString) {
            Structure.Builder vb = (Structure.Builder)((Structure.Builder)((Structure.Builder)Structure.builder().setName(shortName)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimString);
            this.rootGroup.addVariable(vb);
            return vb;
        }

        public NetcdfFormatWriter build() throws IOException {
            return new NetcdfFormatWriter(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

