/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.Earth;

@Immutable
public class EarthEllipsoid
extends Earth {
    private static final Map<String, EarthEllipsoid> hash = new LinkedHashMap<String, EarthEllipsoid>(10);
    public static final EarthEllipsoid WGS84 = new EarthEllipsoid("WGS84", 7030, 6378137.0, 298.257223563);
    public static final EarthEllipsoid Airy1830 = new EarthEllipsoid("Airy 1830", 7001, 6377563.396, 299.3249646);
    public static final EarthEllipsoid IAU = new EarthEllipsoid("IAU 1965", -1, 6378160.0, 297.0);
    public static final EarthEllipsoid IAG_GRS80 = new EarthEllipsoid("IIAG-GRS80", -1, 6378137.0, 298.257222101);
    private final int epsgId;

    public static Collection<EarthEllipsoid> getAll() {
        return hash.values();
    }

    @Nullable
    public static EarthEllipsoid getType(String name) {
        if (name == null) {
            return null;
        }
        return hash.get(name);
    }

    @Nullable
    public static EarthEllipsoid getType(int epsgId) {
        Collection<EarthEllipsoid> all = EarthEllipsoid.getAll();
        for (EarthEllipsoid ellipsoid : all) {
            if (ellipsoid.epsgId != epsgId) continue;
            return ellipsoid;
        }
        return null;
    }

    private EarthEllipsoid(String name, int epsgId, double a, double invF) {
        this(name, epsgId, a, 0.0, invF);
    }

    public EarthEllipsoid(String name, int epsgId, double a, double b, double invF) {
        super(a, b, invF, name);
        this.epsgId = epsgId;
        hash.put(name, this);
    }

    public int getEpsgId() {
        return this.epsgId;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarthEllipsoid)) {
            return false;
        }
        EarthEllipsoid oe = (EarthEllipsoid)o;
        return oe.getName().equals(this.getName());
    }
}

