/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;

@Immutable
public class EarthLocation {
    private final double latitude;
    private final double longitude;
    private final double altitude;
    private final String altUnits;

    public static EarthLocation create(double lat, double lon, double alt) {
        return new EarthLocation(lat, lon, alt, null);
    }

    public static EarthLocation create(double lat, double lon, double alt, String altUnits) {
        return new EarthLocation(lat, lon, alt, altUnits);
    }

    EarthLocation(double latitude, double longitude, double altitude, String altUnits) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.altUnits = altUnits;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    @Nullable
    public String getAltitudeUnits() {
        return this.altUnits;
    }

    public LatLonPoint getLatLon() {
        return LatLonPoint.create(this.getLatitude(), this.getLongitude());
    }

    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarthLocation that = (EarthLocation)o;
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(that.longitude, this.longitude) != 0) {
            return false;
        }
        if (Double.compare(that.altitude, this.altitude) != 0) {
            return false;
        }
        return this.altUnits != null ? this.altUnits.equals(that.altUnits) : that.altUnits == null;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.altUnits != null ? this.altUnits.hashCode() : 0);
        return result;
    }
}

