/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.auto.value.AutoValue;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.AutoValue_LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;

@AutoValue
public abstract class LatLonPoint {
    public static LatLonPoint INVALID = LatLonPoint.create(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public static LatLonPoint create(double lat, double lon) {
        return new AutoValue_LatLonPoint(LatLonPoints.latNormal(lat), LatLonPoints.lonNormal(lon));
    }

    public abstract double getLatitude();

    public abstract double getLongitude();

    public boolean nearlyEquals(LatLonPoint that) {
        return this.nearlyEquals(that, 1.0E-8);
    }

    public boolean nearlyEquals(LatLonPoint that, double maxRelDiff) {
        boolean lonOk = Misc.nearlyEquals(that.getLongitude(), this.getLongitude(), maxRelDiff);
        if (!lonOk) {
            lonOk = Misc.nearlyEquals(LatLonPoints.lonNormal360(that.getLongitude()), LatLonPoints.lonNormal360(this.getLongitude()), maxRelDiff);
        }
        return lonOk && Misc.nearlyEquals(that.getLatitude(), this.getLatitude(), maxRelDiff);
    }

    public String toString() {
        return LatLonPoints.toString(this, 5);
    }
}

