/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.common.base.Splitter;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.util.Format;

public class LatLonPoints {
    public static boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        return (lon = LatLonPoints.lonNormalFrom(lon, lonBeg)) <= (lonEnd = LatLonPoints.lonNormalFrom(lon, lonEnd));
    }

    public static double lonNormal360(double lon) {
        return LatLonPoints.lonNormal(lon, 180.0);
    }

    public static double lonNormal(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double lonNormalFrom(double lon, double start) {
        while (lon < start) {
            lon += 360.0;
        }
        while (lon > start + 360.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public static double lonNormal(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double lonDiff(double lon1, double lon2) {
        return Math.IEEEremainder(lon1 - lon2, 360.0);
    }

    public static double latNormal(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        return Math.min(lat, 90.0);
    }

    public static String latToString(double lat, int ndec) {
        boolean is_north;
        boolean bl = is_north = lat >= 0.0;
        if (!is_north) {
            lat = -lat;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, lat);
        latBuff.format("%s", is_north ? "N" : "S");
        return latBuff.toString();
    }

    public static String lonToString(double lon, int ndec) {
        boolean is_east;
        double wlon = LatLonPoints.lonNormal(lon);
        boolean bl = is_east = wlon >= 0.0;
        if (!is_east) {
            wlon = -wlon;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, wlon);
        latBuff.format("%s", is_east ? "E" : "W");
        return latBuff.toString();
    }

    public static boolean isInfinite(ProjectionPoint pt) {
        return pt.getX() == Double.POSITIVE_INFINITY || pt.getX() == Double.NEGATIVE_INFINITY || pt.getY() == Double.POSITIVE_INFINITY || pt.getY() == Double.NEGATIVE_INFINITY;
    }

    public static double range180(double lon) {
        return LatLonPoints.lonNormal(lon);
    }

    public static String toString(LatLonPoint pt, int sigDigits) {
        return String.format("%s, %s", Format.d(pt.getLatitude(), sigDigits), Format.d(pt.getLongitude(), sigDigits));
    }

    @Nullable
    public static LatLonPoint parseLatLonPoint(String source) {
        List ss = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)source);
        if (ss.size() != 2) {
            return null;
        }
        try {
            double lat = Double.parseDouble((String)ss.get(0));
            double lon = Double.parseDouble((String)ss.get(1));
            return LatLonPoint.create(lat, lon);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(ProjectionPoint pt, int sigDigits) {
        return String.format("%s, %s", Format.d(pt.getX(), sigDigits), Format.d(pt.getY(), sigDigits));
    }
}

