/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.util.Format;

@Immutable
public class LatLonRect {
    public static LatLonRect INVALID = LatLonRect.builder(LatLonPoint.INVALID, LatLonPoint.INVALID).build();
    private final LatLonPoint upperRight;
    private final LatLonPoint lowerLeft;
    private final boolean crossDateline;
    private final boolean allLongitude;
    private final double width;

    public LatLonRect() {
        this(new Builder(LatLonPoint.create(-90.0, -180.0), 180.0, 360.0));
    }

    public LatLonRect(LatLonPoint p1, double deltaLat, double deltaLon) {
        this(LatLonRect.builder(p1, deltaLat, deltaLon));
    }

    public LatLonRect(double lat0, double lon0, double lat1, double lon1) {
        this(LatLonRect.builder(lat0, lon0, lat1, lon1));
    }

    public LatLonPoint getUpperRightPoint() {
        return this.upperRight;
    }

    public LatLonPoint getLowerLeftPoint() {
        return this.lowerLeft;
    }

    public LatLonPoint getUpperLeftPoint() {
        return LatLonPoint.create(this.upperRight.getLatitude(), this.lowerLeft.getLongitude());
    }

    public LatLonPoint getLowerRightPoint() {
        return LatLonPoint.create(this.lowerLeft.getLatitude(), this.upperRight.getLongitude());
    }

    public boolean crossDateline() {
        return this.crossDateline;
    }

    public boolean isAllLongitude() {
        return this.allLongitude;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.getLatMax() - this.getLatMin();
    }

    public double getCenterLon() {
        double lon0 = (this.upperRight.getLongitude() + this.lowerLeft.getLongitude()) / 2.0;
        if (this.crossDateline) {
            lon0 -= 180.0;
        }
        return lon0;
    }

    public double getLonMin() {
        return this.lowerLeft.getLongitude();
    }

    public double getLonMax() {
        return this.lowerLeft.getLongitude() + this.width;
    }

    public double getLatMin() {
        return this.lowerLeft.getLatitude();
    }

    public double getLatMax() {
        return this.upperRight.getLatitude();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLonRect that = (LatLonRect)o;
        return Objects.equals(this.upperRight, that.upperRight) && Objects.equals(this.lowerLeft, that.lowerLeft);
    }

    public int hashCode() {
        return Objects.hash(this.upperRight, this.lowerLeft);
    }

    public boolean nearlyEquals(LatLonRect other) {
        return this.nearlyEquals(other, 1.0E-5f);
    }

    public boolean nearlyEquals(LatLonRect other, double maxRelDiff) {
        return this.getLowerLeftPoint().nearlyEquals(other.getLowerLeftPoint(), maxRelDiff) && this.getUpperRightPoint().nearlyEquals(other.getUpperRightPoint(), maxRelDiff);
    }

    public boolean contains(LatLonPoint p) {
        return this.contains(p.getLatitude(), p.getLongitude());
    }

    public boolean contains(double lat, double lon) {
        double eps = 1.0E-9;
        if (lat + eps < this.lowerLeft.getLatitude() || lat - eps > this.upperRight.getLatitude()) {
            return false;
        }
        if (this.allLongitude) {
            return true;
        }
        if (this.crossDateline) {
            return lon >= this.lowerLeft.getLongitude() || lon <= this.upperRight.getLongitude();
        }
        return lon >= this.lowerLeft.getLongitude() && lon <= this.upperRight.getLongitude();
    }

    public boolean containedIn(LatLonRect b) {
        return b.getWidth() >= this.width && b.contains(this.upperRight) && b.contains(this.lowerLeft);
    }

    @Nullable
    public LatLonRect intersect(LatLonRect clip) {
        double lon2max;
        double lon2min;
        double lon1max;
        double latMin = Math.max(this.getLatMin(), clip.getLatMin());
        double latMax = Math.min(this.getLatMax(), clip.getLatMax());
        double deltaLat = latMax - latMin;
        if (deltaLat < 0.0) {
            return null;
        }
        double lon1min = this.getLonMin();
        if (!this.intersect(lon1min, lon1max = this.getLonMax(), lon2min = clip.getLonMin(), lon2max = clip.getLonMax()) && !this.intersect(lon1min, lon1max, lon2min = clip.getLonMin() + 360.0, lon2max = clip.getLonMax() + 360.0)) {
            lon2min = clip.getLonMin() - 360.0;
            lon2max = clip.getLonMax() - 360.0;
        }
        double lonMin = Math.max(lon1min, lon2min);
        double lonMax = Math.min(lon1max, lon2max);
        double deltaLon = lonMax - lonMin;
        if (deltaLon < 0.0) {
            return null;
        }
        return new Builder(LatLonPoint.create(latMin, lonMin), deltaLat, deltaLon).build();
    }

    private boolean intersect(double min1, double max1, double min2, double max2) {
        double max;
        double min = Math.max(min1, min2);
        return min < (max = Math.min(max1, max2));
    }

    public String toString1() {
        return " ll: " + this.lowerLeft + " ur: " + this.upperRight + " width: " + this.width + " cross: " + this.crossDateline + " all: " + this.allLongitude;
    }

    public String toString2() {
        return " lat= [" + Format.dfrac(this.getLatMin(), 2) + "," + Format.dfrac(this.getLatMax(), 2) + "] lon= [" + Format.dfrac(this.getLonMin(), 2) + "," + Format.dfrac(this.getLonMax(), 2) + "]";
    }

    public String toString() {
        return String.format("%f, %f, %f, %f", this.lowerLeft.getLatitude(), this.lowerLeft.getLongitude(), this.getHeight(), this.getWidth());
    }

    public Builder toBuilder() {
        return new Builder(this.lowerLeft, this.upperRight.getLatitude() - this.lowerLeft.getLatitude(), this.width);
    }

    @Deprecated
    public static Builder builder(LatLonPoint left, LatLonPoint right) {
        double width;
        for (width = right.getLongitude() - left.getLongitude(); width < 0.0; width += 360.0) {
        }
        if (width == 0.0) {
            width = 360.0;
        }
        return new Builder(left, right.getLatitude() - left.getLatitude(), width);
    }

    public static Builder builder(LatLonPoint p1, double deltaLat, double deltaLon) {
        return new Builder().init(p1, deltaLat, deltaLon);
    }

    public static Builder builder(double lat0, double lon0, double lat1, double lon1) {
        double width = lon1 - lon0;
        if (Math.abs(width) < 1.0E-8) {
            width = 360.0;
        }
        return new Builder().init(LatLonPoint.create(lat0, lon0), lat1 - lat0, width);
    }

    @Nullable
    public static LatLonRect fromSpec(String spec) {
        StringTokenizer stoker = new StringTokenizer(spec, " ,");
        int n = stoker.countTokens();
        if (n != 4) {
            throw new IllegalArgumentException("Must be 4 numbers = lat, lon, latWidth, lonWidth");
        }
        double lat = Double.parseDouble(stoker.nextToken());
        double lon = Double.parseDouble(stoker.nextToken());
        double deltaLat = Double.parseDouble(stoker.nextToken());
        double deltaLon = Double.parseDouble(stoker.nextToken());
        return new Builder().init(LatLonPoint.create(lat, lon), deltaLat, deltaLon).build();
    }

    @Deprecated
    public static Builder builder(String spec) {
        StringTokenizer stoker = new StringTokenizer(spec, " ,");
        int n = stoker.countTokens();
        if (n != 4) {
            throw new IllegalArgumentException("Must be 4 numbers = lat, lon, latWidth, lonWidth");
        }
        double lat = Double.parseDouble(stoker.nextToken());
        double lon = Double.parseDouble(stoker.nextToken());
        double deltaLat = Double.parseDouble(stoker.nextToken());
        double deltaLon = Double.parseDouble(stoker.nextToken());
        return new Builder().init(LatLonPoint.create(lat, lon), deltaLat, deltaLon);
    }

    private LatLonRect(Builder builder) {
        this.lowerLeft = LatLonPoint.create(builder.llLat, builder.llLon);
        this.upperRight = LatLonPoint.create(builder.urLat, builder.urLon);
        this.crossDateline = builder.crossDateline;
        this.allLongitude = builder.allLongitudes;
        this.width = builder.width;
    }

    public static class Builder {
        double llLat;
        double llLon;
        double urLat;
        double urLon;
        double width;
        boolean allLongitudes;
        boolean crossDateline;

        private Builder() {
        }

        @Deprecated
        public Builder(LatLonPoint left, LatLonPoint right) {
            this(left, right.getLatitude() - left.getLatitude(), LatLonPoints.lonNormal360(right.getLongitude() - left.getLongitude()));
        }

        @Deprecated
        public Builder(String spec) {
            StringTokenizer stoker = new StringTokenizer(spec, " ,");
            int n = stoker.countTokens();
            if (n != 4) {
                throw new IllegalArgumentException("Must be 4 numbers = lat, lon, latWidth, lonWidth");
            }
            double lat = Double.parseDouble(stoker.nextToken());
            double lon = Double.parseDouble(stoker.nextToken());
            double deltaLat = Double.parseDouble(stoker.nextToken());
            double deltaLon = Double.parseDouble(stoker.nextToken());
            this.init(LatLonPoint.create(lat, lon), deltaLat, deltaLon);
        }

        @Deprecated
        public Builder(LatLonPoint p1, double deltaLat, double deltaLon) {
            this.init(p1, deltaLat, deltaLon);
        }

        private Builder init(LatLonPoint p1, double deltaLat, double deltaLon) {
            double lonpt;
            double latmin = Math.min(p1.getLatitude(), p1.getLatitude() + deltaLat);
            double latmax = Math.max(p1.getLatitude(), p1.getLatitude() + deltaLat);
            while (deltaLon < 0.0) {
                deltaLon += 360.0;
            }
            while (deltaLon > 360.0) {
                deltaLon -= 360.0;
            }
            double lonmin = lonpt = p1.getLongitude();
            double lonmax = lonpt + deltaLon;
            this.crossDateline = lonmax > 180.0;
            this.width = deltaLon;
            this.allLongitudes = this.width >= 360.0;
            this.llLat = latmin;
            this.llLon = LatLonPoints.lonNormal(lonmin);
            this.urLat = latmax;
            this.urLon = LatLonPoints.lonNormal(lonmax);
            return this;
        }

        public Builder(double startLat, double startLon) {
            this.llLat = startLat;
            this.urLat = startLat;
            this.urLon = this.llLon = LatLonPoints.lonNormal(startLon);
            this.allLongitudes = false;
            this.crossDateline = false;
            this.width = 0.0;
        }

        public Builder extend(LatLonRect r) {
            Preconditions.checkNotNull((Object)r);
            Preconditions.checkNotNull((Object)r);
            double latMin = r.getLatMin();
            double latMax = r.getLatMax();
            if (latMax > this.urLat) {
                this.urLat = latMax;
            }
            if (latMin < this.llLat) {
                this.llLat = latMin;
            }
            if (this.allLongitudes) {
                return this;
            }
            double lonMin = this.llLon;
            double lonMax = this.llLon + this.width;
            double nlonMin = LatLonPoints.lonNormal(r.getLonMin(), lonMin);
            double nlonMax = nlonMin + r.getWidth();
            lonMin = Math.min(lonMin, nlonMin);
            lonMax = Math.max(lonMax, nlonMax);
            this.width = lonMax - lonMin;
            boolean bl = this.allLongitudes = this.width >= 360.0;
            if (this.allLongitudes) {
                this.width = 360.0;
                lonMin = -180.0;
            } else {
                lonMin = LatLonPoints.lonNormal(lonMin);
            }
            this.llLon = LatLonPoints.lonNormal(lonMin);
            this.urLon = LatLonPoints.lonNormal(lonMin + this.width);
            this.crossDateline = this.llLon > this.urLon;
            return this;
        }

        public Builder extend(LatLonPoint latlon) {
            return this.extend(latlon.getLatitude(), latlon.getLongitude());
        }

        public Builder extend(double lat, double lon) {
            if (this.contains(lat, lon = LatLonPoints.lonNormal(lon))) {
                return this;
            }
            if (lat > this.urLat) {
                this.urLat = lat;
            }
            if (lat < this.llLat) {
                this.llLat = lat;
            }
            if (!this.allLongitudes) {
                if (this.crossDateline) {
                    double d1 = lon - this.urLon;
                    double d2 = this.llLon - lon;
                    if (d1 > 0.0 && d2 > 0.0) {
                        if (d1 > d2) {
                            this.llLon = lon;
                        } else {
                            this.urLon = lon;
                        }
                    }
                } else if (lon > this.urLon) {
                    if (lon - this.urLon > this.llLon - lon + 360.0) {
                        this.crossDateline = true;
                        this.llLon = lon;
                    } else {
                        this.urLon = lon;
                    }
                } else if (lon < this.llLon) {
                    if (this.llLon - lon > lon + 360.0 - this.urLon) {
                        this.crossDateline = true;
                        this.urLon = lon;
                    } else {
                        this.llLon = lon;
                    }
                }
            }
            this.width = this.urLon - this.llLon;
            if (this.crossDateline) {
                this.width += 360.0;
            }
            this.allLongitudes = this.allLongitudes || this.width >= 360.0;
            return this;
        }

        private boolean contains(double lat, double lon) {
            double eps = 1.0E-9;
            if (lat + eps < this.llLat || lat - eps > this.urLat) {
                return false;
            }
            if (this.allLongitudes) {
                return true;
            }
            if (this.crossDateline) {
                return lon >= this.llLon || lon <= this.urLon;
            }
            return lon >= this.llLon && lon <= this.urLon;
        }

        public Builder extendToAllLongitudes(double minWidth) {
            if (this.crossDateline && this.width > minWidth) {
                this.llLon = -180.0;
                this.urLon = 180.0;
                this.allLongitudes = true;
            }
            return this;
        }

        public Builder expand(double delta) {
            this.llLat -= delta;
            this.urLat += delta;
            this.llLon -= delta;
            this.urLon += delta;
            return this;
        }

        public LatLonRect build() {
            return new LatLonRect(this);
        }
    }
}

