/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.common.math.DoubleMath;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.unidata.geoloc.ProjectionPoint;

@Immutable
public class ProjectionRect {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public ProjectionRect() {
        this(-5000.0, -5000.0, 5000.0, 5000.0);
    }

    public ProjectionRect(ProjectionPoint corner1, ProjectionPoint corner2) {
        this(corner1.getX(), corner1.getY(), corner2.getX(), corner2.getY());
    }

    public ProjectionRect(ProjectionPoint minimum, double width, double height) {
        this.x = minimum.getX();
        this.y = minimum.getY();
        this.width = width;
        this.height = height;
    }

    public ProjectionRect(double x1, double y1, double x2, double y2) {
        this.width = Math.abs(x1 - x2);
        this.height = Math.abs(y1 - y2);
        double wx0 = 0.5 * (x1 + x2);
        double wy0 = 0.5 * (y1 + y2);
        this.x = wx0 - this.width / 2.0;
        this.y = wy0 - this.height / 2.0;
    }

    @Nullable
    public static ProjectionRect fromSpec(String spec) {
        StringTokenizer stoker = new StringTokenizer(spec, " ,");
        int n = stoker.countTokens();
        if (n != 4) {
            return null;
        }
        try {
            double x = Double.parseDouble(stoker.nextToken());
            double y = Double.parseDouble(stoker.nextToken());
            double width = Double.parseDouble(stoker.nextToken());
            double height = Double.parseDouble(stoker.nextToken());
            return ProjectionRect.builder().setX(x).setY(y).setWidth(width).setHeight(height).build();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public ProjectionRect(String spec) {
        StringTokenizer stoker = new StringTokenizer(spec, " ,");
        int n = stoker.countTokens();
        if (n != 4) {
            throw new IllegalArgumentException("Must be 4 numbers = lat, lon, latWidth, lonWidth");
        }
        this.x = Double.parseDouble(stoker.nextToken());
        this.y = Double.parseDouble(stoker.nextToken());
        this.width = Double.parseDouble(stoker.nextToken());
        this.height = Double.parseDouble(stoker.nextToken());
    }

    @Deprecated
    public double getX() {
        return this.x;
    }

    @Deprecated
    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean intersects(ProjectionRect r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public static ProjectionRect intersect(ProjectionRect src1, ProjectionRect src2) {
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        return ProjectionRect.builder().setX(x1).setY(y1).setWidth(x2 - x1).setHeight(y2 - y1).build();
    }

    public boolean contains(ProjectionPoint point) {
        return DoubleMath.fuzzyCompare((double)point.getX(), (double)this.getMinX(), (double)1.0E-6) >= 0 && DoubleMath.fuzzyCompare((double)point.getX(), (double)this.getMaxX(), (double)1.0E-6) <= 0 && DoubleMath.fuzzyCompare((double)point.getY(), (double)this.getMinY(), (double)1.0E-6) >= 0 && DoubleMath.fuzzyCompare((double)point.getY(), (double)this.getMaxY(), (double)1.0E-6) <= 0;
    }

    public boolean contains(ProjectionRect rect) {
        boolean contained = this.equals(rect) ? true : this.contains(rect.getMinPoint()) && this.contains(rect.getMaxPoint());
        return contained;
    }

    public ProjectionPoint getLowerRightPoint() {
        return ProjectionPoint.create(this.getMaxPoint().getX(), this.getMinPoint().getY());
    }

    public ProjectionPoint getUpperRightPoint() {
        return this.getMaxPoint();
    }

    public ProjectionPoint getLowerLeftPoint() {
        return this.getMinPoint();
    }

    public ProjectionPoint getUpperLeftPoint() {
        return ProjectionPoint.create(this.getMinPoint().getX(), this.getMaxPoint().getY());
    }

    public ProjectionPoint getMinPoint() {
        return ProjectionPoint.create(this.getX(), this.getY());
    }

    public ProjectionPoint getMaxPoint() {
        return ProjectionPoint.create(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public String toString1() {
        return String.format("min: %.3f %.3f size: %.3f %.3f", this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public String toString2(int ndec) {
        String f = " %." + ndec + "f";
        return String.format("min:" + f + f + " max:" + f + f, this.getX(), this.getY(), this.getMaxX(), this.getMaxY());
    }

    public String toString() {
        return String.format("%f, %f, %f, %f", this.x, this.y, this.getWidth(), this.getHeight());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectionRect that = (ProjectionRect)o;
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        return Double.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean nearlyEquals(ProjectionRect other) {
        return this.nearlyEquals(other, 1.0E-5f);
    }

    public boolean nearlyEquals(ProjectionRect other, double maxRelDiff) {
        return this.getLowerLeftPoint().nearlyEquals(other.getLowerLeftPoint(), maxRelDiff) && this.getUpperRightPoint().nearlyEquals(other.getUpperRightPoint(), maxRelDiff);
    }

    private ProjectionRect(Builder builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
    }

    public Builder toBuilder() {
        return ProjectionRect.builder().setX(this.x).setY(this.y).setWidth(this.width).setHeight(this.height);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(double x1, double y1, double x2, double y2) {
        double wx0 = 0.5 * (x1 + x2);
        double wy0 = 0.5 * (y1 + y2);
        double width = Math.abs(x1 - x2);
        double height = Math.abs(y1 - y2);
        return new Builder().setWidth(width).setHeight(height).setX(wx0 - width / 2.0).setY(wy0 - height / 2.0);
    }

    public static class Builder {
        private double x;
        private double y;
        private double width;
        private double height;

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public Builder setX(double x) {
            this.x = x;
            return this;
        }

        public Builder setY(double y) {
            this.y = y;
            return this;
        }

        public Builder setWidth(double width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(double height) {
            this.height = height;
            return this;
        }

        public Builder setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            return this;
        }

        public Builder setRect(ProjectionRect r) {
            return this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        public Builder add(ProjectionRect r) {
            double x1 = Math.min(this.x, r.getMinX());
            double x2 = Math.max(this.x + this.height, r.getMaxX());
            double y1 = Math.min(this.y, r.getMinY());
            double y2 = Math.max(this.y + this.height, r.getMaxY());
            this.x = x1;
            this.y = y1;
            this.width = x2 - x1;
            this.height = y2 - y1;
            return this;
        }

        public Builder add(double newx, double newy) {
            double x1 = Math.min(this.x, newx);
            double x2 = Math.max(this.x + this.height, newx);
            double y1 = Math.min(this.y, newy);
            double y2 = Math.max(this.y + this.height, newy);
            this.x = x1;
            this.y = y1;
            this.width = x2 - x1;
            this.height = y2 - y1;
            return this;
        }

        public Builder add(ProjectionPoint pt) {
            this.add(pt.getX(), pt.getY());
            return this;
        }

        public ProjectionRect build() {
            return new ProjectionRect(this);
        }
    }
}

